/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.xtrip.common.kkt.atol.model.AtolQueue;
import com.gridnine.xtrip.common.kkt.atol.model.ReceiptObject;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.PaymentObject;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.kkt.atol.model.common.VatType;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AtolHelper {
    public static final String LK_URL = AtolHelper.class.getName() + ".LK_URL";
    public static final String DOWNLOAD_URL = AtolHelper.class.getName() + ".DOWNLOAD_URL";
    public static final String CHARSET = "UTF-8";
    public static final String WAIT_CODE = "34";
    public static final String BASE_URL = "https://lk.platformaofd.ru";
    private static Map<ReceiptVatType, VatType> vatTypeMap = new HashMap<ReceiptVatType, VatType>();
    private static Map<PaymentMethod, String> paymentMethodMap;
    private static Map<PaymentObject, String> paymentObjectMap;
    private static Map<PaymentType, Integer> paymentTypeMap;

    public static String buildUrlParametersString(Map<String, String> urlParameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : urlParameters.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue() == null ? "" : URLEncoder.encode(entry.getValue(), CHARSET));
        }
        return sb.toString();
    }

    public static String getSno(Organization organization) {
        if (organization.isSimpleTaxed()) {
            return "usn_income";
        }
        return "osn";
    }

    public static VatType convertVatTypeToGds(ReceiptVatType value) {
        return vatTypeMap.get(value);
    }

    public static String convertPaymentMethodToGds(PaymentMethod value) {
        return paymentMethodMap.get(value);
    }

    public static String convertPaymentObjectToGds(PaymentObject value) {
        return paymentObjectMap.get(value);
    }

    public static Integer convertPaymentTypeToGds(PaymentType value) {
        return paymentTypeMap.get(value);
    }

    public static void fillAtolQueue(AtolQueue atolQueue, AtolSettings atolSettings) {
        atolQueue.setCreated(LocalDateTime.now());
        int kktAmount = atolSettings.getKktAmount();
        if (kktAmount < 1) {
            kktAmount = 1;
        }
        atolQueue.setAvailable(kktAmount);
        atolQueue.setProcessed(0);
    }

    public static Message message(List<Message> messages, Predicate<String> l10nMessageKeyPredicate, Supplier<Message> newMessageSupplier) {
        Objects.requireNonNull(messages);
        Objects.requireNonNull(l10nMessageKeyPredicate);
        Objects.requireNonNull(newMessageSupplier);
        return messages.stream().filter(Objects::nonNull).filter(message -> Optional.of(message).map(Message::getMessage).map(L10nMessage::getKey).filter(l10nMessageKeyPredicate).isPresent()).findAny().orElseGet(() -> {
            Message newMessage = (Message)newMessageSupplier.get();
            messages.add(newMessage);
            return newMessage;
        });
    }

    public static boolean isDownloadable(ReceiptObject receiptObject) {
        return Objects.nonNull(receiptObject) && Objects.nonNull(receiptObject.getFnNumber()) && Objects.nonNull(receiptObject.getFiscalDocumentAttribute()) && Objects.nonNull(receiptObject.getFiscalDocumentNumber());
    }

    public static String toLkUrl(ReceiptObject receiptObject) {
        if (!AtolHelper.isDownloadable(receiptObject)) {
            throw new IllegalArgumentException("receipt not downloadable");
        }
        return BASE_URL + String.format("/web/noauth/cheque?fn=%s&fp=%s&i=%s", receiptObject.getFnNumber(), receiptObject.getFiscalDocumentAttribute(), receiptObject.getFiscalDocumentNumber());
    }

    public static String convertPhoneNumberToGds(String number) {
        if (TextUtil.nonBlank((String)number)) {
            String num = number.trim();
            if (num.startsWith("8") && num.length() == 11) {
                return num.replaceFirst("8", "");
            }
            return num;
        }
        return null;
    }

    static {
        vatTypeMap.put(ReceiptVatType.NONE, VatType.NONE);
        vatTypeMap.put(ReceiptVatType.VAT_0, VatType.VAT0);
        vatTypeMap.put(ReceiptVatType.VAT_5, VatType.VAT5);
        vatTypeMap.put(ReceiptVatType.VAT_7, VatType.VAT7);
        vatTypeMap.put(ReceiptVatType.VAT_10, VatType.VAT10);
        vatTypeMap.put(ReceiptVatType.VAT_18, VatType.VAT18);
        vatTypeMap.put(ReceiptVatType.VAT_5_105, VatType.VAT105);
        vatTypeMap.put(ReceiptVatType.VAT_7_107, VatType.VAT107);
        vatTypeMap.put(ReceiptVatType.VAT_10_110, VatType.VAT110);
        vatTypeMap.put(ReceiptVatType.VAT_18_118, VatType.VAT118);
        vatTypeMap.put(ReceiptVatType.VAT_20, VatType.VAT20);
        vatTypeMap.put(ReceiptVatType.VAT_20_120, VatType.VAT120);
        paymentMethodMap = new HashMap<PaymentMethod, String>();
        paymentMethodMap.put(PaymentMethod.FULL_PREPAYMENT, "full_prepayment");
        paymentMethodMap.put(PaymentMethod.PREPAYMENT, "prepayment");
        paymentMethodMap.put(PaymentMethod.ADVANCE, "advance");
        paymentMethodMap.put(PaymentMethod.FULL_PAYMENT, "full_payment");
        paymentMethodMap.put(PaymentMethod.PARTIAL_PAYMENT, "partial_payment");
        paymentMethodMap.put(PaymentMethod.CREDIT, "credit");
        paymentMethodMap.put(PaymentMethod.CREDIT_PAYMENT, "credit_payment");
        paymentObjectMap = new HashMap<PaymentObject, String>();
        paymentObjectMap.put(PaymentObject.COMMODITY, "commodity");
        paymentObjectMap.put(PaymentObject.EXCISE, "excise");
        paymentObjectMap.put(PaymentObject.JOB, "job");
        paymentObjectMap.put(PaymentObject.SERVICE, "service");
        paymentObjectMap.put(PaymentObject.GAMBLING_BET, "gambling_bet");
        paymentObjectMap.put(PaymentObject.GAMBLING_PRIZE, "gambling_prize");
        paymentObjectMap.put(PaymentObject.LOTTERY, "lottery");
        paymentObjectMap.put(PaymentObject.LOTTERY_PRIZE, "lottery_prize");
        paymentObjectMap.put(PaymentObject.INTELLECTUAL_ACTIVITY, "intellectual_activity");
        paymentObjectMap.put(PaymentObject.PAYMENT, "payment");
        paymentObjectMap.put(PaymentObject.AGENT_COMMISSION, "agent_commission");
        paymentObjectMap.put(PaymentObject.COMPOSITE, "composite");
        paymentObjectMap.put(PaymentObject.OTHER, "another");
        paymentTypeMap = new HashMap<PaymentType, Integer>();
        paymentTypeMap.put(PaymentType.ELECTRONIC, 1);
        paymentTypeMap.put(PaymentType.PREPAYMENT, 2);
        paymentTypeMap.put(PaymentType.CREDIT, 3);
        paymentTypeMap.put(PaymentType.OTHER, 4);
    }
}

