/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestOperation;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestParameters;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.stream.Collectors;

public class AtolHttpRequestBuilder
extends BaseProcessor {
    private static String VERSION = "v4";

    public void process(MessageContext ctx) throws Exception {
        AtolRequestParameters reqParams = (AtolRequestParameters)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_PARAMS);
        EntityContainer atolSettingsCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_SETTINGS);
        AtolSettings atolSettings = (AtolSettings)atolSettingsCtr.getEntity();
        if (Objects.isNull(atolSettings.getAddress())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(this.buildUrl(atolSettings, reqParams));
        if (reqParams.getRequest() != null) {
            httpRequest.setBody(this.buildContent(reqParams.getRequest()));
        }
        AtolRequestOperation operation = reqParams.getOperation();
        httpRequest.setRequestMethod(operation.getMethod());
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/json;charset=utf-8");
        if (operation != AtolRequestOperation.GET_TOKEN) {
            httpRequest.getRequestProperties().put((Object)"Token", (Object)atolSettings.getToken());
        }
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)atolSettings.getPassword());
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private String buildUrl(AtolSettings settings, AtolRequestParameters reqParams) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(settings.getAddress().toString()).append("/");
        sb.append(VERSION).append("/");
        if (reqParams.getOperation() != AtolRequestOperation.GET_TOKEN) {
            sb.append(settings.getGroupCode()).append("/");
        }
        sb.append(reqParams.getOperation().getValue());
        if (CollectionUtil.isNotEmpty(reqParams.getPathParameters())) {
            String pathParameters = reqParams.getPathParameters().stream().collect(Collectors.joining("/"));
            sb.append("/").append(pathParameters);
        }
        if (!reqParams.getUrlParameters().isEmpty()) {
            sb.append("?").append(AtolHelper.buildUrlParametersString(reqParams.getUrlParameters()));
        }
        return sb.toString();
    }

    private byte[] buildContent(Object request) throws Exception {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                return new JsonWriter(writer, 1);
            }
        });
        xstream.processAnnotations(request.getClass());
        xstream.setMode(1001);
        String content = xstream.toXML(request);
        return content.getBytes("UTF-8");
    }
}

