/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestParameters;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolTokenExpiredException;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.kkt.atol.model.BaseAtolResponse;
import com.gridnine.xtrip.server.kkt.atol.model.common.Status;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.util.Objects;
import java.util.regex.Pattern;

public class AtolHttpResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AtolRequestParameters reqParams = (AtolRequestParameters)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_PARAMS);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        this.checkResponse(httpResponse, reqParams.getResponseClass());
        BaseAtolResponse baseResponse = this.parseHttpResponse(httpResponse.getBody(), reqParams.getResponseClass());
        this.checkErrors(baseResponse);
        ctx.putObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_RESPONSE, (Object)baseResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkResponse(HttpResponse response, Class responseClass) {
        if (response.getBody() != null) {
            return;
        }
        if (response.getError() == null) {
            throw Xeption.forDeveloper((String)"response is null, code = {0}, message = {1}", (Object[])new Object[]{response.getResponseCode(), response.getResponseMessage()});
        }
        try {
            BaseAtolResponse baseResponse = this.parseHttpResponse(response.getError(), responseClass);
            this.checkErrors(baseResponse);
            if (!"33".equals(baseResponse.getError().getCode())) {
                // empty if block
            }
        }
        catch (Throwable baseResponse) {
            // empty catch block
        }
        String errorContent = new String(response.getError());
        if (Pattern.compile("\"code\"\\s*:\\s*11").matcher(errorContent).find()) {
            throw new AtolTokenExpiredException();
        }
        throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{errorContent});
    }

    private BaseAtolResponse parseHttpResponse(byte[] content, Class responseClass) {
        String body = new String(content);
        body = "{\"response\": " + body + "}";
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xstream.alias("response", responseClass);
        xstream.allowTypes(new Class[]{responseClass});
        xstream.autodetectAnnotations(true);
        xstream.ignoreUnknownElements();
        return (BaseAtolResponse)xstream.fromXML(body);
    }

    private void checkErrors(BaseAtolResponse baseResponse) {
        BaseAtolResponse.ErrorInfo error = baseResponse.getError();
        if (this.reportNotReady(error)) {
            return;
        }
        if (this.errorExists(error)) {
            throw Xeption.forDeveloper((String)"id={0}, code={1}: {2}", (Object[])new Object[]{error.getId(), error.getCode(), error.getText()});
        }
        if (baseResponse.getStatus() == Status.FAIL) {
            throw Xeption.forDeveloper((String)"status = failed", (Object[])new Object[0]);
        }
    }

    private boolean reportNotReady(BaseAtolResponse.ErrorInfo error) {
        return Objects.nonNull(error) && TextUtil.isSame((String)"34", (String)error.getCode());
    }

    private boolean errorExists(BaseAtolResponse.ErrorInfo error) {
        if (error == null) {
            return false;
        }
        return TextUtil.nonBlank((String)error.getCode()) || TextUtil.nonBlank((String)error.getId()) || TextUtil.nonBlank((String)error.getText());
    }
}

