/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLog;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLogPart;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class AtolTracingDocumentAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = IbusConfigurationHelper.getOptionalParameter(params, (String)"doc-name");
    }

    public void before(MessageContext ctx) throws Exception {
        GdsTracingDocument document = new GdsTracingDocument();
        document.setName("atol-" + this.docName);
        document.setCreated(new Date());
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT, (Object)document);
    }

    public void after(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        if (Objects.isNull(document) || CollectionUtil.isEmpty((Collection)document.getParts())) {
            return;
        }
        ReceiptLog receiptLog = new ReceiptLog();
        receiptLog.setName(document.getName());
        receiptLog.setCreated(document.getCreated());
        document.getParts().stream().filter(Objects::nonNull).map(gdsTracingDocumentPart -> {
            ReceiptLogPart receiptLogPart = new ReceiptLogPart();
            receiptLogPart.setName(gdsTracingDocumentPart.getName());
            receiptLogPart.setGlobalData(GdsTracingHelper.getGlobalDataAsString((GdsTracingDocumentPart)gdsTracingDocumentPart));
            return receiptLogPart;
        }).forEach(receiptLog.getParts()::add);
        ((Receipt)receiptCtr.getEntity()).getLogs().add(receiptLog);
        EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
        docCtr.getVersionInfo().setDataSource(this.docName);
        EntityStorage.get().save(docCtr, false);
    }
}

