/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.xtrip.common.kkt.atol.model.AtolQueue;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class GetAtolQueueTemporalObjectProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        EntityContainer atolSettingsCtr = EntityStorageHelper.resolve((EntityReference)receipt.getAtolSettings());
        TemporalObject temporalObject = this.find((EntityContainer<AtolSettings>)atolSettingsCtr);
        if (Objects.isNull(temporalObject)) {
            temporalObject = this.create((EntityContainer<AtolSettings>)atolSettingsCtr);
        }
        ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_QUEUE_TEMPORAL_OBJECT, (Object)temporalObject);
    }

    private TemporalObject create(EntityContainer<AtolSettings> atolSettingCtr) throws Exception {
        TemporalObject temporalObject = new TemporalObject();
        temporalObject.setExpired(MiscUtil.addDaysToDate((Date)new Date(), (int)1));
        String tag = this.tag(atolSettingCtr);
        temporalObject.setTag(tag);
        AtolQueue atolQueue = new AtolQueue();
        AtolHelper.fillAtolQueue(atolQueue, (AtolSettings)atolSettingCtr.getEntity());
        temporalObject.setData(XSUtil.toByteArray((XSSerializable)atolQueue));
        return temporalObject;
    }

    private TemporalObject find(EntityContainer<AtolSettings> atolSettingsCtr) {
        SearchQuery searchQuery = new SearchQuery();
        List criterions = searchQuery.getCriteria().getCriterions();
        String tag = this.tag(atolSettingsCtr);
        criterions.add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)tag));
        SearchResult searchResult = LogicalStorage.get().getAssetStorage().search(TemporalObject.class, searchQuery);
        if (EntityStorageHelper.isEmpty((SearchResult)searchResult)) {
            return null;
        }
        return searchResult.getData().stream().filter(Objects::nonNull).filter(temporalObject -> tag.equals(temporalObject.getTag())).findAny().orElse(null);
    }

    private String tag(EntityContainer<AtolSettings> atolSettingsCtr) {
        return "atol.queue.byAtolSettings." + atolSettingsCtr.getUid();
    }
}

