/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus;

import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProcessingType {
    QUEUE(EnumSet.of(ReceiptStatus.REGISTRATION)),
    NOT_QUEUE(Stream.of(ReceiptStatus.values()).filter(receiptStatus -> !ProcessingType.QUEUE.statuses.contains(receiptStatus)).collect(Collectors.toCollection(() -> EnumSet.noneOf(ReceiptStatus.class))));

    final Collection<ReceiptStatus> statuses;

    private ProcessingType(Collection<ReceiptStatus> statuses) {
        this.statuses = statuses;
    }

    static ProcessingType of(ReceiptStatus receiptStatus) {
        return Stream.of(ProcessingType.values()).filter(processingType -> processingType.statuses.contains(receiptStatus)).findAny().get();
    }
}

