/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.checkFormation;

import com.gridnine.xtrip.common.kkt.atol.model.ReceiptObject;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AtolCheckDownloadProcessor
extends BaseProcessor {
    private static final String CHECK_PENDING = "check formation";
    private static final String CHECK_PENDING_FAIL = "fail";
    private static final String CHECK_PENDING_SUCCESS = "success";
    private static final String CHECK_PENDING_MESSAGE = "check formation, {0} attempt, result {1}";

    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        List messages = receipt.getMessages();
        Message checkPendingMessage = AtolHelper.message(messages, key -> key.startsWith(CHECK_PENDING), () -> SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)CHECK_PENDING_MESSAGE, (Object[])new Object[]{0, ""}));
        this.increaseAttempt(checkPendingMessage);
        String progress = "Prepare";
        try {
            ReceiptObject receiptObject = receipt.getReceiptObject();
            String lkUrl = AtolHelper.toLkUrl(receiptObject);
            progress = "Try send " + lkUrl;
            List<String> hrefs = this.hrefs(lkUrl);
            String checkHref = hrefs.stream().filter(href -> href.contains(receiptObject.getFiscalDocumentAttribute())).findAny().orElse(null);
            Objects.requireNonNull(checkHref, "no valid href in " + hrefs);
            String downloadUrl = "https://lk.platformaofd.ru" + checkHref;
            progress = progress + ", try download " + downloadUrl;
            Connection.Response content = Jsoup.connect((String)downloadUrl).ignoreContentType(true).execute();
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"lk url = {0}", (Object[])new Object[]{lkUrl}));
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"download url = {0}", (Object[])new Object[]{downloadUrl}));
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_SUCCESSFUL, (Object)Boolean.TRUE);
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_LK_URL, (Object)lkUrl);
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_DOWNLOAD_URL, (Object)downloadUrl);
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_CONTENT, (Object)content.bodyAsBytes());
            this.setResult(checkPendingMessage, CHECK_PENDING_SUCCESS, "");
        }
        catch (Exception e) {
            this.setResult(checkPendingMessage, CHECK_PENDING_FAIL, String.format("Progress=[%s] exception=%s", progress, TextUtil.getExceptionStackTrace((Throwable)e)));
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_SUCCESSFUL, (Object)Boolean.FALSE);
        }
    }

    private void increaseAttempt(Message message) {
        int attemptIndex = 0;
        List parameters = message.getMessage().getParameters();
        Integer attempt = (Integer)parameters.get(attemptIndex);
        parameters.set(attemptIndex, attempt + 1);
    }

    private void setResult(Message message, String result, String details) {
        int resultIndex = 1;
        message.getMessage().getParameters().set(resultIndex, result);
        message.setDetails(details);
    }

    private List<String> hrefs(String lkUrl) throws IOException {
        String hrefAttr = "href";
        return Jsoup.connect((String)lkUrl).timeout(60000).get().getElementsByAttribute(hrefAttr).stream().map(element -> element.attr(hrefAttr)).filter(href -> href.contains("pdf")).collect(Collectors.toList());
    }
}

