/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.checkFormation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AtolCheckFormationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        String lkUrl = (String)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_LK_URL);
        String downloadUrl = (String)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_DOWNLOAD_URL);
        byte[] content = (byte[])ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_CHECK_CONTENT);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        Document document = new Document();
        document.setType(DocumentType.RECEIPT);
        document.setContentType(ContentType.PDF);
        document.setCreated(new Date());
        document.setContent(content);
        document.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        document.setOwner(receiptCtr.toReference());
        String documentName = downloadUrl.substring(downloadUrl.lastIndexOf(47) + 1);
        document.setName(documentName);
        document.setTitle(documentName);
        String description = Stream.of("\u0427\u0435\u043a \u0410\u0422\u041e\u041b: " + receipt.getDescription(), "\u0410\u0434\u0440\u0435\u0441 \u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0430: " + lkUrl, "\u0421\u043a\u0430\u0447\u0435\u043d\u043e \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435: " + downloadUrl).filter(TextUtil::nonBlank).collect(Collectors.joining(System.lineSeparator()));
        document.setDescription(description);
        List properties = document.getProperties();
        properties.add(NamedValueHelper.namedValue((String)AtolHelper.LK_URL, (String)lkUrl));
        properties.add(NamedValueHelper.namedValue((String)AtolHelper.DOWNLOAD_URL, (String)downloadUrl));
        ctx.putObject((Enum)IBusStandardContextKeys.DOCUMENT, (Object)EntityContainer.create((BaseEntity)document));
    }
}

