/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.registration;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.PaymentData;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestOperation;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestParameters;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.kkt.atol.model.RegistrationRQ;
import com.gridnine.xtrip.server.kkt.atol.model.RegistrationRS;
import com.gridnine.xtrip.server.kkt.atol.model.common.AgentInfoType;
import com.gridnine.xtrip.server.kkt.atol.model.common.VatType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtolRegistrationRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        EntityContainer atolSettingsCtr = EntityStorageHelper.resolve((EntityReference)((Receipt)receiptCtr.getEntity()).getAtolSettings());
        AtolSettings atolSettings = (AtolSettings)atolSettingsCtr.getEntity();
        AtolRequestParameters atolRequestParameters = this.buildRequestParams((EntityContainer<Receipt>)receiptCtr, atolSettings);
        ctx.putObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_PARAMS, (Object)atolRequestParameters);
        ctx.putObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_SETTINGS, (Object)atolSettingsCtr);
    }

    private AtolRequestParameters buildRequestParams(EntityContainer<Receipt> receiptCtr, AtolSettings atolSettings) {
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        ReceiptData receiptData = receipt.getReceiptData();
        AtolRequestOperation operation = this.getOperation(receiptData.getType());
        RegistrationRQ request = this.buildRequest(receiptCtr, atolSettings);
        return new AtolRequestParameters.AtolRequestParametersBuilder(operation, RegistrationRS.class).setRequest(request).build();
    }

    private AtolRequestOperation getOperation(ReceiptType type) {
        if (Objects.isNull(type)) {
            throw Xeption.forDeveloper((String)"ReceiptData.type is null", (Object[])new Object[0]);
        }
        switch (type) {
            case SELL: {
                return AtolRequestOperation.SELL;
            }
            case SELL_REFUND: {
                return AtolRequestOperation.SELL_REFUND;
            }
            case SELL_CORRECTION: {
                return AtolRequestOperation.SELL_CORRECTION;
            }
            case BUY: {
                return AtolRequestOperation.BUY;
            }
            case BUY_REFUND: {
                return AtolRequestOperation.BUY_REFUND;
            }
            case BUY_CORRECTION: {
                return AtolRequestOperation.BUY_CORRECTION;
            }
        }
        throw new UnsupportedOperationException("Unsupported ReceiptData.type");
    }

    private RegistrationRQ buildRequest(EntityContainer<Receipt> receiptCtr, AtolSettings atolSettings) {
        RegistrationRQ registrationRQ = new RegistrationRQ();
        registrationRQ.setExternalId(receiptCtr.getUid());
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        ReceiptData receiptData = receipt.getReceiptData();
        registrationRQ.setReceipt(this.buildReceipt(receiptData, atolSettings));
        return registrationRQ;
    }

    protected RegistrationRQ.Receipt buildReceipt(ReceiptData receiptData, AtolSettings atolSettings) {
        RegistrationRQ.Receipt result = new RegistrationRQ.Receipt();
        result.setClient(this.buildClient(receiptData));
        result.setCompany(this.buildCompany(atolSettings));
        this.addItems(result, receiptData.getItems());
        for (PaymentData paymentData : receiptData.getPayments()) {
            result.getPayments().add(this.buildPayment(paymentData));
        }
        return result;
    }

    protected RegistrationRQ.Client buildClient(ReceiptData data) {
        String clientEmail = data.getClentEmail();
        if (TextUtil.isBlank((String)clientEmail)) {
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d email", (Object[])new Object[0]);
        }
        RegistrationRQ.Client result = new RegistrationRQ.Client();
        if (Objects.nonNull(data.getClient())) {
            EntityContainer clientCtr = EntityStorageHelper.resolve((EntityReference)data.getClient());
            if (clientCtr == null || clientCtr.getEntity() == null) {
                throw Xeption.forEndUser((String)"\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f-\u043a\u043b\u0438\u0435\u043d\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0430!", (Object[])new Object[0]);
            }
            result.setName(((Organization)clientCtr.getEntity()).getFullName().toString());
            String registrationId = ((Organization)clientCtr.getEntity()).getRegistrationId();
            if (TextUtil.isBlank((String)registrationId)) {
                registrationId = "000000000000";
            }
            result.setInn(registrationId);
        }
        result.setEmail(clientEmail);
        return result;
    }

    protected RegistrationRQ.Company buildCompany(AtolSettings atolSettings) {
        EntityContainer agencyCtr = EntityStorage.get().resolve(atolSettings.getKktOwner());
        Organization agency = (Organization)agencyCtr.getEntity();
        RegistrationRQ.Company company = new RegistrationRQ.Company();
        company.setEmail(atolSettings.getEmail());
        company.setPaymentAddress(atolSettings.getWebSite());
        company.setInn(agency.getRegistrationId());
        company.setSno(AtolHelper.getSno(agency));
        return company;
    }

    protected void addItems(RegistrationRQ.Receipt result, List<ReceiptLine> items) {
        BigDecimal total = BigDecimal.ZERO;
        HashMap<VatType, BigDecimal> vats = new HashMap<VatType, BigDecimal>();
        for (ReceiptLine receiptLine : items) {
            RegistrationRQ.ReceiptItem ri = new RegistrationRQ.ReceiptItem();
            ri.setName(receiptLine.getPrintName());
            ri.setPrice(receiptLine.getPrice());
            ri.setQuantity(receiptLine.getQuantity());
            BigDecimal itemTotal = receiptLine.getTotal();
            ri.setSum(itemTotal);
            VatType type = AtolHelper.convertVatTypeToGds(receiptLine.getVatType());
            RegistrationRQ.ReceiptItemVat riv = new RegistrationRQ.ReceiptItemVat();
            riv.setType(type);
            riv.setSum(receiptLine.getVatAmount());
            ri.setVat(riv);
            if (receiptLine.getSupplier() != null) {
                RegistrationRQ.Supplier supplier = new RegistrationRQ.Supplier();
                supplier.setName(receiptLine.getSupplier().getName());
                supplier.setInn(receiptLine.getSupplier().getINN());
                Optional.ofNullable(AtolHelper.convertPhoneNumberToGds(receiptLine.getSupplier().getPhoneNum())).ifPresent(num -> supplier.getPhones().add((String)num));
                ri.setAgentInfo(new RegistrationRQ.AgentInfo(AgentInfoType.ANOTHER));
                ri.setSupplierInfo(supplier);
            }
            ri.setPaymentMethod(AtolHelper.convertPaymentMethodToGds(receiptLine.getPaymentMethod()));
            ri.setPaymentObject(AtolHelper.convertPaymentObjectToGds(receiptLine.getPaymentObject()));
            result.getItems().add(ri);
            this.updateVats(vats, type, receiptLine.getVatAmount());
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, itemTotal});
        }
        for (Map.Entry entry : vats.entrySet()) {
            RegistrationRQ.ReceiptVat rv = new RegistrationRQ.ReceiptVat();
            rv.setType((VatType)((Object)entry.getKey()));
            rv.setSum((BigDecimal)entry.getValue());
            result.getVats().add(rv);
        }
        result.setTotal(total);
    }

    private void updateVats(Map<VatType, BigDecimal> vats, VatType type, BigDecimal vatAmount) {
        BigDecimal curValue = MiscUtil.guarded((BigDecimal)vats.get((Object)type));
        vats.put(type, MiscUtil.sum((BigDecimal[])new BigDecimal[]{curValue, vatAmount}));
    }

    private RegistrationRQ.ReceiptPayment buildPayment(PaymentData paymentData) {
        RegistrationRQ.ReceiptPayment result = new RegistrationRQ.ReceiptPayment();
        result.setType(AtolHelper.convertPaymentTypeToGds(paymentData.getType()));
        result.setSum(paymentData.getAmount());
        return result;
    }
}

