/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.report;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptStatus;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AtolReportCheckExpiredProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        List messages = receipt.getMessages();
        Date registrationDate = receipt.getRegistrationDate();
        if (Objects.isNull(registrationDate)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"no registrationDate", (Object[])new Object[0]));
            receipt.setStatus(ReceiptStatus.ERROR);
            throw new IllegalStateException("no registrationDate");
        }
        int expireDays = 32;
        Date checkDate = MiscUtil.addDaysToDate((Date)registrationDate, (int)expireDays);
        boolean expire = checkDate.before(new Date());
        if (expire) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0448\u043b\u043e \u0431\u043e\u043b\u0435\u0435 {0} \u0441\u0443\u0442\u043e\u043a, \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0441\u043b\u0443\u0436\u0431\u0443 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u0410\u0422\u041e\u041b \u041e\u043d\u043b\u0430\u0439\u043d, \u0443\u043a\u0430\u0437\u0430\u0432 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438, \u043a\u043e\u0434 \u0433\u0440\u0443\u043f\u043f\u044b \u0438 \u043f\u0435\u0440\u0438\u043e\u0434 \u043f\u043e \u0434\u0430\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0447\u0435\u043a\u043e\u0432, \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b \u0434\u0430\u043d\u043d\u044b\u0435.", (Object[])new Object[]{expireDays}));
            receipt.setStatus(ReceiptStatus.ERROR);
            throw new IllegalStateException("expired report request");
        }
    }
}

