/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.report;

import com.gridnine.xtrip.common.kkt.atol.model.AtolQueue;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class AtolReportQueueAdvice
extends BaseAdvice {
    private static final long periodMs = 1000L;

    public void before(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        AtolQueue atolQueue = (AtolQueue)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_QUEUE);
        this.byReceipt((Receipt)receiptCtr.getEntity());
        this.byAtolQueue(atolQueue);
    }

    public void after(MessageContext ctx) throws Exception {
        AtolQueue atolQueue = (AtolQueue)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.ATOL_QUEUE);
        EntityContainer atolSettingsCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_SETTINGS);
        long betweenMs = this.betweenMs(atolQueue.getCreated());
        if (betweenMs >= 1000L) {
            AtolHelper.fillAtolQueue(atolQueue, (AtolSettings)atolSettingsCtr.getEntity());
        } else {
            int processed = atolQueue.getProcessed();
            atolQueue.setProcessed(processed + 1);
        }
    }

    private void byReceipt(Receipt receipt) throws Exception {
        long registrationDelayMs = 10000L;
        long betweenMs = this.betweenMs(MiscUtil.toLocalDateTime((Date)receipt.getRegistrationDate()));
        if (betweenMs >= registrationDelayMs) {
            return;
        }
        TimeUnit.MILLISECONDS.sleep(registrationDelayMs - betweenMs);
    }

    private void byAtolQueue(AtolQueue atolQueue) throws Exception {
        long betweenMs = this.betweenMs(atolQueue.getCreated());
        if (betweenMs >= 1000L) {
            return;
        }
        if (atolQueue.getAvailable() - atolQueue.getProcessed() > 0) {
            return;
        }
        TimeUnit.MILLISECONDS.sleep(1000L - betweenMs);
    }

    private long betweenMs(Temporal start) {
        return Duration.between(start, LocalDateTime.now()).toMillis();
    }
}

