/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.report;

import com.gridnine.xtrip.common.kkt.atol.model.ReceiptObject;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestOperation;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolRequestParameters;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.kkt.atol.model.ReportRS;

public class AtolReportRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        EntityContainer atolSettingsCtr = EntityStorageHelper.resolve((EntityReference)receipt.getAtolSettings());
        AtolSettings atolSettings = (AtolSettings)atolSettingsCtr.getEntity();
        AtolRequestParameters atolRequestParameters = this.buildRequestParams(receipt);
        ctx.putObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_PARAMS, (Object)atolRequestParameters);
        ctx.putObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_SETTINGS, (Object)atolSettingsCtr);
    }

    private AtolRequestParameters buildRequestParams(Receipt receipt) {
        ReceiptObject receiptObject = receipt.getReceiptObject();
        return new AtolRequestParameters.AtolRequestParametersBuilder(AtolRequestOperation.REPORT, ReportRS.class).addPathParameters(receiptObject.getAtolUid()).build();
    }
}

