/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.report;

import com.gridnine.xtrip.common.kkt.atol.model.ReceiptObject;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.AtolHelper;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.kkt.atol.model.BaseAtolResponse;
import com.gridnine.xtrip.server.kkt.atol.model.ReportRS;
import java.util.List;
import java.util.Optional;

public class AtolReportResponseParser
extends BaseProcessor {
    private static final String REPORT_PENDING = "report pending";
    private static final String REPORT_PENDING_FAIL = "fail";
    private static final String REPORT_PENDING_SUCCESS = "success";
    private static final String REPORT_PENDING_MESSAGE = "report pending, {0} attempt, result {1}";

    public void process(MessageContext ctx) throws Exception {
        EntityContainer receiptCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.RECEIPT);
        ReportRS response = (ReportRS)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_RESPONSE);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        Message reportPendingMessage = AtolHelper.message(receipt.getMessages(), key -> key.startsWith(REPORT_PENDING), () -> SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)REPORT_PENDING_MESSAGE, (Object[])new Object[]{0, ""}));
        this.increaseAttempt(reportPendingMessage);
        String errorCode = Optional.of(response).map(BaseAtolResponse::getError).map(BaseAtolResponse.ErrorInfo::getCode).orElse(null);
        if ("34".equals(errorCode)) {
            this.setResult(reportPendingMessage, REPORT_PENDING_FAIL, "get wait code");
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_REPORT_SUCCESSFUL, (Object)Boolean.FALSE);
            return;
        }
        ReportRS.Payload payload = response.getPayload();
        boolean fnNumberPresent = Optional.ofNullable(payload).map(ReportRS.Payload::getFnNumber).isPresent();
        if (!fnNumberPresent) {
            this.setResult(reportPendingMessage, REPORT_PENDING_FAIL, "not present fn number");
            ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_REPORT_SUCCESSFUL, (Object)Boolean.FALSE);
            return;
        }
        ReceiptObject receiptObject = receipt.getReceiptObject();
        receiptObject.setFiscalReceiptNumber(payload.getFiscalReceiptNumber());
        receiptObject.setShiftNumber(payload.getShiftNumber());
        receiptObject.setReceiptDatetime(payload.getReceiptDatetime());
        receiptObject.setTotal(payload.getTotal());
        receiptObject.setFnNumber(payload.getFnNumber());
        receiptObject.setEcrRegistrationNumber(payload.getEcrRegistrationNumber());
        receiptObject.setFiscalDocumentNumber(payload.getFiscalDocumentNumber());
        receiptObject.setFiscalDocumentAttribute(payload.getFiscalDocumentAttribute());
        receiptObject.setFnsSite(payload.getFnsSite());
        this.setResult(reportPendingMessage, REPORT_PENDING_SUCCESS, "");
        ctx.putObject((Enum)IBusKktAtolContextKeys.ATOL_REPORT_SUCCESSFUL, (Object)Boolean.TRUE);
    }

    private void setResult(Message message, String result, String details) {
        int resultIndex = 1;
        message.getMessage().getParameters().set(resultIndex, result);
        message.setDetails(details);
    }

    private void increaseAttempt(Message message) {
        int attemptIndex = 0;
        List parameters = message.getMessage().getParameters();
        Integer attempt = (Integer)parameters.get(attemptIndex);
        parameters.set(attemptIndex, attempt + 1);
    }
}

