/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.kkt.atol.ibus.updateToken;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.kkt.atol.ibus.IBusKktAtolContextKeys;
import com.gridnine.xtrip.server.kkt.atol.model.GetTokenRS;
import java.time.LocalDateTime;

public class AtolGetTokenResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetTokenRS response = (GetTokenRS)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_RESPONSE);
        EntityContainer atolSettingsCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusKktAtolContextKeys.KKT_ATOL_REQUEST_SETTINGS);
        AtolSettings atolSettings = (AtolSettings)atolSettingsCtr.getEntity();
        String token = response.getToken();
        if (TextUtil.isBlank((String)token)) {
            throw Xeption.forDeveloper((String)"token is null", (Object[])new Object[0]);
        }
        atolSettings.setToken(token);
        atolSettings.setTokenTimeLimit(LocalDateTime.now().plusHours(24L).minusMinutes(2L));
        VersionInfo versionInfo = atolSettingsCtr.getVersionInfo();
        versionInfo.setDataSource("atol");
        versionInfo.setVersionNotes("update-token");
        EntityStorage.get().save(atolSettingsCtr, true);
    }
}

