/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.server.ServerApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityHelper {
    private static SecurityHelper instance;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final KeyStore store;
    private final String pwd;

    public static String buildMessage(String title, byte[] data) {
        return SecurityHelper.buildMessage(title, Base64.encode((byte[])data));
    }

    public static String buildMessage(String title, String data) {
        return "-----BEGIN " + title + "-----\r\n" + data + "\r\n-----END " + title + "-----";
    }

    public static boolean verify(byte[] publicKey, String algorithm, byte[] data, byte[] signature) throws GeneralSecurityException {
        Signature sig = Signature.getInstance(algorithm);
        sig.initVerify(KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey)));
        sig.update(data);
        return sig.verify(signature);
    }

    public static byte[] encryptSecretKey(byte[] publicKey, String algorithm, byte[] secretKey) throws GeneralSecurityException {
        Cipher enc = Cipher.getInstance(algorithm);
        enc.init(1, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey)));
        return enc.doFinal(secretKey);
    }

    public static synchronized SecurityHelper getInstance() throws GeneralSecurityException {
        if (instance != null) {
            return instance;
        }
        try {
            ExtendedProperties config = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
            instance = new SecurityHelper(new File(config.getProperty("keystore.file", null)), config.getProperty("keystore.password", null));
        }
        catch (GeneralSecurityException gse) {
            throw gse;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("failed configuring security helper", e);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityHelper(File file, String encodedPassword) throws GeneralSecurityException, IOException {
        this.pwd = encodedPassword;
        this.store = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream strm = new FileInputStream(file);){
            this.store.load(strm, DesUtil.decode((String)encodedPassword).toCharArray());
        }
        this.log.info("loaded from " + file);
    }

    public KeyStore getKeyStore() {
        return this.store;
    }

    public String getPassword() {
        return this.pwd;
    }

    public byte[] sign(String alias, String algorithm, byte[] data) throws GeneralSecurityException, IOException {
        Signature sig = Signature.getInstance(algorithm);
        sig.initSign(this.getPrivateKeyEntry(alias).getPrivateKey());
        sig.update(data);
        return sig.sign();
    }

    public byte[] decryptSecretKey(String alias, String algorithm, byte[] data) throws GeneralSecurityException, IOException {
        Cipher enc = Cipher.getInstance(algorithm);
        enc.init(2, this.getPrivateKeyEntry(alias).getPrivateKey());
        return enc.doFinal(data);
    }

    public Certificate getPrivateKeyCerfificate(String alias) throws GeneralSecurityException, IOException {
        return this.getPrivateKeyEntry(alias).getCertificate();
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias) throws GeneralSecurityException, IOException {
        KeyStore.PrivateKeyEntry result = (KeyStore.PrivateKeyEntry)this.store.getEntry(alias, new KeyStore.PasswordProtection(DesUtil.decode((String)this.pwd).toCharArray()));
        if (result == null) {
            throw new IOException("no entry found in key store for alias " + alias);
        }
        this.log.debug(String.format("found private key entry for alias %s : %s", alias, result.getClass().getName()));
        return result;
    }
}

