/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice;

import com.gridnine.bof.midoffice.SecurityHelper;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.RandomUtil;
import com.gridnine.xtrip.server.ServerApplication;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SecurityHelperTest
extends TestBase {
    private static final String KEYSTORE = "./config/server/keystore";
    private static final String ALIAS = "test-keypair";
    private SecurityHelper securityHelper;

    public void setUp() throws Exception {
        super.setUp();
        Class.forName(ServerApplication.class.getName());
        Properties config = new Properties();
        try (FileInputStream strm = new FileInputStream("./config/server/boot.properties");){
            config.load(strm);
        }
        this.securityHelper = new SecurityHelper(new File(KEYSTORE), config.getProperty("com.gridnine.xtrip.server.keystore.password"));
    }

    @Test
    public void testSign() throws Exception {
        String algorithm = "SHA1withRSA";
        byte[] data = RandomUtil.getRandomBytes((int)10000, (int)10000);
        byte[] signature = this.securityHelper.sign(ALIAS, algorithm, data);
        Assert.assertTrue((boolean)SecurityHelper.verify(this.securityHelper.getPrivateKeyCerfificate(ALIAS).getPublicKey().getEncoded(), algorithm, data, signature));
    }

    @Test
    public void testSSLHandshake() throws Exception {
        String algorithm = "RSA/ECB/PKCS1Padding";
        byte[] secretKeyData = KeyGenerator.getInstance("DES").generateKey().getEncoded();
        byte[] encrypted = SecurityHelper.encryptSecretKey(this.securityHelper.getPrivateKeyCerfificate(ALIAS).getPublicKey().getEncoded(), algorithm, secretKeyData);
        byte[] decrypted = this.securityHelper.decryptSecretKey(ALIAS, algorithm, encrypted);
        Assert.assertTrue((boolean)Arrays.equals(secretKeyData, decrypted));
    }

    @Test
    public void testPublicKey() throws Exception {
        byte[] data = this.securityHelper.getPrivateKeyCerfificate(ALIAS).getPublicKey().getEncoded();
        byte[] signature = this.securityHelper.sign(ALIAS, "SHA1withRSA", data);
        byte[] digest = MessageDigest.getInstance("SHA-1").digest(data);
        this.log.debug(String.format("Public key for %s:\r\n%s", ALIAS, SecurityHelper.buildMessage("PUBLIC KEY", data)));
        this.log.debug(String.format("Public key SHA1withRSA signature for %s:\r\n%s", ALIAS, SecurityHelper.buildMessage("SIGNATURE", signature)));
        this.log.debug(String.format("Public key SHA-1 digest for %s:\r\n%s", ALIAS, SecurityHelper.buildMessage("DIGEST", digest)));
    }
}

