/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.cache;

import com.gridnine.bof.midoffice.cache.CacheEntryHandler;
import com.gridnine.bof.midoffice.cache.CacheWorker;
import com.gridnine.bof.midoffice.cache.MapEntryHandler;
import com.gridnine.bof.midoffice.cache.ObjectWrapper;
import com.gridnine.bof.midoffice.cache.XmlEntryHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.slf4j.LoggerFactory;

public class CacheService {
    public static final CacheEntryHandler<org.w3c.dom.Element> XML_HANDLER = new XmlEntryHandler();
    public static final CacheEntryHandler<Map<String, String>> STRING_MAP_HANDLER = new MapEntryHandler<String, String>();
    private CacheManager cacheManager;

    public CacheService(URL config, File folder) throws IOException {
        try {
            this.cacheManager = this.createCacheManager(config, folder);
        }
        catch (AssertionError err) {
            IoUtil.emptyFolder((File)folder);
            this.cacheManager = this.createCacheManager(config, folder);
        }
        LoggerFactory.getLogger(this.getClass()).info(String.format("configured, config=%s, dataFolder=%s", config, folder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheManager createCacheManager(URL config, File folder) throws IOException {
        Configuration cacheConfig;
        try (InputStream strm = config.openStream();){
            cacheConfig = ConfigurationFactory.parseConfiguration((InputStream)strm);
        }
        DiskStoreConfiguration dsc = cacheConfig.getDiskStoreConfiguration();
        if (TextUtil.isBlank((String)dsc.getPath())) {
            dsc.setPath(folder.getCanonicalPath());
        }
        return new CacheManager(cacheConfig);
    }

    public void dispose() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
        LoggerFactory.getLogger(this.getClass()).info("disposed");
    }

    public <K, V> CacheWorker<K, V> createWorker(String cacheName, final CacheEntryHandler<K> keyHandler, final CacheEntryHandler<V> valueHandler) {
        final Ehcache cache = this.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        return new CacheWorker<K, V>(){

            @Override
            public V get(K key) {
                ObjectWrapper ow = new ObjectWrapper(keyHandler, key);
                Element result = cache.get(ow);
                if (result == null) {
                    return null;
                }
                return ((ObjectWrapper)result.getValue()).getData();
            }

            @Override
            public void put(int timeoutInSeconds, K key, V value) {
                Element element = new Element(new ObjectWrapper(keyHandler, key), new ObjectWrapper(valueHandler, value));
                element.setTimeToLive(timeoutInSeconds);
                cache.put(element);
            }

            @Override
            public void remove(K key) {
                cache.remove(new ObjectWrapper(keyHandler, key));
            }
        };
    }

    public Ehcache getCache(String cacheName) {
        if (this.cacheManager == null) {
            return null;
        }
        return this.cacheManager.getEhcache(cacheName);
    }

    public Collection<Ehcache> getCaches() {
        if (this.cacheManager == null) {
            return Collections.emptyList();
        }
        ArrayList<Ehcache> result = new ArrayList<Ehcache>();
        for (String cacheName : this.cacheManager.getCacheNames()) {
            result.add(this.cacheManager.getEhcache(cacheName));
        }
        return result;
    }
}

