/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.cache;

import com.gridnine.bof.midoffice.cache.CacheEntryHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class ObjectWrapper<T>
implements Serializable {
    private static final long serialVersionUID = -4744997106496653058L;
    private final CacheEntryHandler<T> handler;
    private transient T data;
    private transient int hashCode = -1;

    ObjectWrapper(CacheEntryHandler<T> h, T dt) {
        this.handler = h;
        this.data = dt;
    }

    T getData() {
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.handler.getHashCode(this.data);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectWrapper)) {
            return false;
        }
        return this.handler.equals(this.data, ((ObjectWrapper)obj).data);
    }

    private void writeObject(ObjectOutputStream strm) throws IOException {
        strm.defaultWriteObject();
        this.handler.write(strm, this.data);
    }

    private void readObject(ObjectInputStream strm) throws IOException, ClassNotFoundException {
        strm.defaultReadObject();
        this.data = this.handler.read(strm);
    }
}

