/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.cbrrate;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class CbrRateTask
extends BaseScheduledTask {
    private static final String DTF = "dd.MM.yyyy";
    private String url;
    private final Set<String> currencyCodes = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() {
        try {
            long start = System.currentTimeMillis();
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            URL serviceUrl = new URL(this.url);
            URLConnection urlConnection = serviceUrl.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-Type", "text/html; charset=windows-1251");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataInputStream in = new DataInputStream(urlConnection.getInputStream());){
                IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
            }
            byte[] byteArray = out.toByteArray();
            this.log.trace(String.format("CBR request: GET %s;\r\n response: {%s}\r\n;timing = %s msec", this.url, new String(byteArray, "UTF-8"), Long.toString(System.currentTimeMillis() - start)));
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byteArray)).getDocumentElement();
            Date date = MiscUtil.clearTime((Date)new SimpleDateFormat(DTF).parse(root.getAttribute("Date")));
            for (Element elm : XmlUtil.getElements((Element)root, (String)"Valute")) {
                String currencyCode = XHelper.readString((Element)elm, (String)"CharCode");
                if (!this.currencyCodes.isEmpty() && !this.currencyCodes.contains(currencyCode)) {
                    this.log.debug("skipping update of rate for " + currencyCode);
                    continue;
                }
                CbrRateTask.updateCurrencyRate(date, currencyCode, BigDecimal.valueOf(Double.parseDouble(XHelper.readString((Element)elm, (String)"Value").replace(",", "."))).divide(BigDecimal.valueOf(Integer.parseInt(XHelper.readString((Element)elm, (String)"Nominal"))), 20, RoundingMode.HALF_UP), CurrencyRateType.CBR, this.log);
            }
        }
        catch (Exception e) {
            this.log.error("failed updating currency rates", (Throwable)e);
            StringBuilder buf = new StringBuilder();
            buf.append("An error has occurred while updating CBR exchange rates.\r\n");
            buf.append("Details:\r\n").append(TextUtil.getExceptionStackTrace((Throwable)e)).append("\r\n");
            buf.append(MidofficeHelper.getStandardPlainTextFooter("\r\n"));
            MidofficeHelper.sendSystemEmail("CBR exchange rates update failure", buf.toString());
        }
    }

    public static void updateCurrencyRate(Date date, String currencyCode, BigDecimal newRate, CurrencyRateType currencyRateType, Logger logger) {
        try {
            CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)currencyCode, (Date)date, (CurrencyRateType)currencyRateType, (TariffType)TariffType.REGULAR, null);
            if (currencyRate != null && currencyRate.getType() == currencyRateType && currencyRate.getDate() != null && newRate.compareTo(BigDecimal.valueOf(currencyRate.getRate())) == 0) {
                logger.debug(String.format("currency rate not changed for %s, value=%s", currencyCode, newRate));
                return;
            }
            if (currencyRate != null && currencyRate.getType() == currencyRateType && currencyRate.getDate() != null && MiscUtil.compare((Date)date, (Date)MiscUtil.clearTime((Date)currencyRate.getDate())) == 0) {
                DictionaryStorage.get().delete((BaseDictionary)currencyRate);
                logger.debug(String.format("deleted currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
            }
            currencyRate = new CurrencyRate();
            currencyRate.setBaseCurrency("RUB");
            try {
                currencyRate.setCurrency(currencyCode);
            }
            catch (Exception e) {
                logger.warn("failed updating currency rate for code " + currencyCode, (Throwable)e);
                return;
            }
            currencyRate.setRate(newRate.doubleValue());
            currencyRate.setTariffType(TariffType.REGULAR);
            currencyRate.setType(currencyRateType);
            currencyRate.setDate(date);
            currencyRate.setDataSource("CbrRateTask");
            DictionaryStorage.get().save((BaseDictionary)currencyRate);
            logger.debug(String.format("added currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
        }
        catch (Exception e) {
            logger.warn("failed updating currency rate for code " + currencyCode, (Throwable)e);
            StringBuilder buf = new StringBuilder();
            buf.append("An error has occurred while updating CBR exchange rate for code " + currencyCode + ".\r\n");
            buf.append("Details:\r\n").append(TextUtil.getExceptionStackTrace((Throwable)e)).append("\r\n");
            buf.append(MidofficeHelper.getStandardPlainTextFooter("\r\n"));
            MidofficeHelper.sendSystemEmail("CBR exchange rate update for code " + currencyCode + " failure", buf.toString());
        }
    }

    public void configure(Properties config) throws Exception {
        this.url = config.getProperty("url");
        if (TextUtil.isBlank((String)this.url)) {
            this.log.info("cbr service url is not defined");
            return;
        }
        String currencies = config.getProperty("currencies");
        if (!TextUtil.isBlank((String)currencies)) {
            for (String item : currencies.split(",")) {
                if (TextUtil.isBlank((String)item)) continue;
                this.currencyCodes.add(item.trim().toUpperCase());
            }
        }
    }
}

