/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.helper;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stringtemplate.v4.ST;

public class JsonTestUtil {
    public static void compare(String sample, String actual) throws WrongTypeException, WrongValueException, WrongArraySizeException, JSONException {
        JSONObject sampleObj = new JSONObject(sample);
        JSONObject actualObj = new JSONObject(actual);
        JsonTestUtil.compare(sampleObj, actualObj);
    }

    public static void compare(JSONObject sample, JSONObject actual) throws WrongTypeException, WrongValueException, WrongArraySizeException, JSONException {
        Iterator it = sample.keys();
        while (it.hasNext()) {
            Object key = it.next();
            String keyStr = MiscUtil.toString(key);
            Object sampleSub = sample.has(keyStr) ? sample.get(keyStr) : JSONObject.NULL;
            Object actualSub = actual.has(keyStr) ? actual.get(keyStr) : JSONObject.NULL;
            JsonTestUtil.compare(key, sampleSub, actualSub);
        }
    }

    public static void compare(JSONArray sampleArr, JSONArray actualArr) throws WrongTypeException, WrongValueException, WrongArraySizeException, JSONException {
        JsonTestUtil.compare((Object)"", sampleArr, actualArr);
    }

    private static void compare(Object key, JSONArray sampleArr, JSONArray actualArr) throws WrongTypeException, WrongValueException, WrongArraySizeException, JSONException {
        if (sampleArr.length() != actualArr.length()) {
            throw new WrongArraySizeException(key, sampleArr.length(), actualArr.length());
        }
        for (int i = 0; i < sampleArr.length(); ++i) {
            Object sampleItem = sampleArr.get(i);
            boolean passed = false;
            WrongValueException wveSaved = null;
            WrongTypeException wteSaved = null;
            WrongArraySizeException waseSaved = null;
            for (int j = 0; j < actualArr.length(); ++j) {
                Object actualItem = actualArr.get(j);
                try {
                    JsonTestUtil.compare(key, sampleItem, actualItem);
                    passed = true;
                    break;
                }
                catch (WrongValueException wve) {
                    wveSaved = wve;
                    continue;
                }
                catch (WrongTypeException wte) {
                    wteSaved = wte;
                    continue;
                }
                catch (WrongArraySizeException wase) {
                    waseSaved = wase;
                }
            }
            if (passed) continue;
            if (wveSaved != null) {
                throw wveSaved;
            }
            if (waseSaved != null) {
                throw waseSaved;
            }
            if (wteSaved == null) continue;
            throw wteSaved;
        }
    }

    private static void compare(Object key, Object sampleVal, Object actualVal) throws WrongTypeException, WrongValueException, WrongArraySizeException, JSONException {
        if (sampleVal == null || actualVal == null) {
            if (!MiscUtil.equals((Object)sampleVal, (Object)actualVal)) {
                throw new WrongValueException(key, sampleVal, actualVal);
            }
        } else if (sampleVal instanceof JSONArray) {
            if (!(actualVal instanceof JSONArray)) {
                throw new WrongTypeException(key, JSONArray.class, actualVal.getClass());
            }
            JsonTestUtil.compare(key, (JSONArray)sampleVal, (JSONArray)actualVal);
        } else if (sampleVal instanceof JSONObject) {
            if (!(actualVal instanceof JSONObject)) {
                throw new WrongTypeException(key, JSONObject.class, actualVal.getClass());
            }
            JsonTestUtil.compare((JSONObject)sampleVal, (JSONObject)actualVal);
        } else if (sampleVal instanceof Number) {
            if (!(actualVal instanceof Number)) {
                throw new WrongTypeException(key, Number.class, actualVal.getClass());
            }
            Number sampleNum = (Number)sampleVal;
            Number actualNum = (Number)actualVal;
            if (new BigDecimal(sampleNum.toString()).compareTo(new BigDecimal(actualNum.toString())) != 0) {
                throw new WrongValueException(key, sampleNum, actualNum);
            }
        } else if (!MiscUtil.equals((Object)sampleVal, (Object)actualVal)) {
            throw new WrongValueException(key, sampleVal, actualVal);
        }
    }

    public static String getJson(Class cls, String fileName, Map<String, String> params) throws IOException {
        InputStream in = cls.getResourceAsStream(fileName);
        InputStreamReader reader = new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        IoUtil.copyStream((Reader)reader, (Appendable)writer, (int)512);
        String json = writer.toString();
        ST template = new ST(json);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            template.add(entry.getKey(), (Object)entry.getValue());
        }
        json = template.render();
        return json;
    }

    public static class WrongArraySizeException
    extends JsonComparatorException {
        public final int expected;
        public final int actual;

        public WrongArraySizeException(Object key, int expected, int actual) {
            super(key);
            this.expected = expected;
            this.actual = actual;
        }

        @Override
        public String getMessage() {
            return this.prefix() + "arrays have different sizes: expected " + this.expected + ", got " + this.actual;
        }
    }

    public static class WrongValueException
    extends JsonComparatorException {
        public final Object expected;
        public final Object actual;

        public WrongValueException(Object key, Object a, Object b) {
            super(key);
            this.expected = a;
            this.actual = b;
        }

        @Override
        public String getMessage() {
            return this.prefix() + "expected <" + this.expected + ">, got <" + this.actual + ">";
        }
    }

    public static class WrongTypeException
    extends JsonComparatorException {
        public final Class expected;
        public final Class actual;

        public WrongTypeException(Object key, Class expected, Class actual) {
            super(key);
            this.expected = expected;
            this.actual = actual;
        }

        @Override
        public String getMessage() {
            return this.prefix() + "expected type \"" + this.expected + "\" , got \"" + this.actual + "\"";
        }
    }

    public static abstract class JsonComparatorException
    extends Exception {
        public final Object key;

        public JsonComparatorException(Object key) {
            this.key = key;
        }

        protected String prefix() {
            return "for \"" + this.key + "\", ";
        }
    }
}

