/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MidofficeHelper {
    private static final Logger log = LoggerFactory.getLogger(MidofficeHelper.class);
    public static final String KEY_ONLINE_OPERATION_NAME = "operation-name";
    public static final String VALUE_ONLINE_OPERATION_TICKETING = "ticket";
    public static final String VALUE_ONLINE_OPERATION_REFUND = "refund";
    public static final String VALUE_ONLINE_OPERATION_EXCHANGE = "auto-exchange";
    public static final String VALUE_ONLINE_OPERATION_CHECK_RESERVATION = "check-reservation";
    public static final String VALUE_ONLINE_OPERATION_CHECK_ASYNC_TICKETING = "check-async-ticketing";
    public static final String IGNORE_IN_PROCESS_WORKFLOW_STATUS_CHANGE = "IGNORE_IN_PROCESS_WORKFLOW_STATUS";
    public static final String IGNORE_IN_PROCESS_WORKFLOW_STATUS_INTERCEPTOR = "IGNORE_IN_PROCESS_WORKFLOW_STATUS_INTERCEPTOR";

    public static void sendSystemEmail(String subject, String body) {
        MidofficeHelper.sendSystemEmail(subject, body, false);
    }

    public static void sendSystemEmail(String subject, String body, boolean important) {
        if ("test".equals(Environment.getApplicationId())) {
            return;
        }
        try {
            MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
            if (sender.isEnabled()) {
                MailDocument msg = new MailDocument();
                msg.setFrom(sender.getDefaultFromAddress());
                msg.getTo().add(sender.getAdminAddress());
                msg.setSubject(subject);
                msg.setImportant(important);
                MailPart part = new MailPart();
                part.setContentType(ContentType.TEXT);
                part.setData(body.getBytes("utf-8"));
                msg.setBody(part);
                sender.send(msg);
                log.info(String.format("system email \"%s\" sent", subject));
            } else {
                log.warn(String.format("system email \"%s\" not sent because mail service disabled", subject));
            }
        }
        catch (Exception e) {
            log.error("failed sending system email", (Throwable)e);
        }
    }

    public static void sendCustomerEmail(String subject, String body, String recipient, List<MailPart> attachments, boolean important) {
        if ("test".equals(Environment.getApplicationId())) {
            return;
        }
        try {
            MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
            if (sender.isEnabled()) {
                MailDocument msg = new MailDocument();
                msg.setFrom(sender.getDefaultFromAddress());
                MailAddress address = new MailAddress();
                address.setAddress(recipient);
                msg.getTo().add(address);
                msg.setSubject(subject);
                msg.setImportant(important);
                MailPart part = new MailPart();
                part.setContentType(ContentType.TEXT);
                part.setData(body.getBytes("utf-8"));
                msg.setBody(part);
                if (attachments != null) {
                    for (MailPart mailPart : attachments) {
                        msg.getAttachments().add(mailPart);
                    }
                }
                sender.send(msg);
                log.info(String.format("customer email \"%s\" sent to \"%s\"", subject, recipient));
            } else {
                log.warn(String.format("customer email \"%s\" not sent to \"%s\" because mail service disabled", subject, recipient));
            }
        }
        catch (Exception e) {
            log.error("failed sending customer email", (Throwable)e);
        }
    }

    public static String getStandardPlainTextFooter(String lineSeparator) {
        return "-----------------------------------------------------------------------" + lineSeparator + "Generated by Midoffice AS " + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()) + lineSeparator + "Application ID: " + Environment.getApplicationId() + ". Instance ID: " + Environment.getInstanceId() + lineSeparator;
    }

    public static Collection<Reservation> getReservations(EntityContainer<BookingFile> bookingFileCtr, Collection<Reservation> reservations) {
        return MidofficeHelper.getReservations((BookingFile)bookingFileCtr.getEntity(), reservations);
    }

    public static Collection<Reservation> getReservations(BookingFile bookingFile, Collection<Reservation> reservations) {
        return reservations != null ? (Collection)bookingFile.getReservations().stream().filter(reservations::contains).collect(Collectors.toList()) : bookingFile.getReservations();
    }

    public static Reservation getReservation(BookingFile bookingFile, Reservation reservation) {
        return bookingFile.getReservations().stream().filter(r -> Objects.equals(r, reservation)).findFirst().orElse(null);
    }

    private MidofficeHelper() {
    }
}

