/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.helper;

import com.gridnine.bof.midoffice.helper.PDFContent;
import com.gridnine.bof.midoffice.helper.PDFContentPart;
import com.gridnine.bof.midoffice.helper.PDFImage;
import com.gridnine.bof.midoffice.helper.PDFUtilLogic;
import com.gridnine.bof.midoffice.helper.PdfSheet;

public final class PDFUtil {
    private static final PDFUtilLogic LOGIC = new PDFUtilLogic();

    public static byte[] wrapAsPDF(String strFooter, PDFContent ... parts) throws Exception {
        return PDFUtil.wrapAsPdf(strFooter, PDFUtil.createPdfSheet(parts));
    }

    public static byte[] wrapAsPdf(String strFooter, PdfSheet ... sheets) throws Exception {
        return LOGIC.wrapAsPdf(strFooter, sheets);
    }

    public static byte[] joinPdf(byte[] ... pdfList) throws Exception {
        return LOGIC.joinPdf(pdfList);
    }

    public static PdfSheet createPdfSheet(PDFContent ... parts) {
        PdfSheet sheet = new PdfSheet();
        if (parts != null) {
            for (PDFContent part : parts) {
                if (part instanceof PDFImage) {
                    sheet.getImages().add((PDFImage)part);
                    continue;
                }
                if (!(part instanceof PDFContentPart)) continue;
                sheet.getTextParts().add((PDFContentPart)part);
            }
        }
        return sheet;
    }

    private PDFUtil() {
    }
}

