/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.helper;

import com.gridnine.bof.midoffice.helper.PDFContentPart;
import com.gridnine.bof.midoffice.helper.PDFImage;
import com.gridnine.bof.midoffice.helper.PDFUtil;
import com.gridnine.bof.midoffice.helper.PdfSheet;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class PDFUtilLogic {
    private static final float LEFT_MARGIN = 27.0f;
    private static final float LINE_HEIGHT = 11.525f;
    private static final float FRAME_MARGIN = 5.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrapAsPdf(String strFooter, PdfSheet ... sheets) throws Exception {
        byte[] byArray;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PDFUtil.class.getClassLoader());
        ByteArrayOutputStream byteOut = null;
        BufferedOutputStream out = null;
        try {
            byteOut = new ByteArrayOutputStream(1024);
            out = new BufferedOutputStream(byteOut);
            BaseFont bf = this.createFont("com/gridnine/bof/midoffice/helper/fonts/DejaVuSansMono.ttf");
            BaseFont bold = this.createFont("com/gridnine/bof/midoffice/helper/fonts/DejaVuSansMono-Bold.ttf");
            Rectangle docRect = new Rectangle(595.0f, 842.0f);
            Document document = new Document(docRect);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)out);
            pdfWriter.setFullCompression();
            pdfWriter.setCloseStream(false);
            HeaderFooter footer = new HeaderFooter(new Phrase(strFooter, new Font(bf, 8.0f)), false);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            PdfContentByte cb = pdfWriter.getDirectContent();
            for (PdfSheet sheet : sheets) {
                document.newPage();
                cb.beginText();
                float imgHeight = this.calculateTotalImageHeight(sheet);
                cb.setTextMatrix(27.0f, 817.5f - imgHeight);
                float ypos = pdfWriter.getVerticalPosition(true);
                for (PDFContentPart textPart : sheet.getTextParts()) {
                    cb.setFontAndSize(this.getFont(bf, bold, textPart), textPart.getFontSize());
                    cb.setCharacterSpacing(textPart.getCharacterSpacing());
                    String[] lines = textPart.getText().split("(\r\n|\n)");
                    float posBegin = ypos;
                    for (String line : lines) {
                        cb.moveText(0.0f, -11.525f);
                        ypos += -11.525f;
                        cb.showText(line);
                    }
                    if (!textPart.isBorder()) continue;
                    this.addBorder(document, cb, ypos - imgHeight, posBegin - imgHeight);
                }
                cb.endText();
                for (PDFImage image : sheet.getImages()) {
                    this.embedImage(image, cb, docRect.getWidth(), docRect.getHeight());
                }
            }
            document.close();
            byArray = byteOut.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(byteOut);
            IOUtils.closeQuietly(out);
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)byteOut);
        IOUtils.closeQuietly((OutputStream)out);
        Thread.currentThread().setContextClassLoader(cl);
        return byArray;
    }

    protected float calculateTotalImageHeight(PdfSheet sheet) {
        if (sheet == null) {
            return 0.0f;
        }
        List<PDFImage> images = sheet.getImages();
        if (images == null) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (PDFImage img : images) {
            if (img == null) continue;
        }
        return sum;
    }

    protected BaseFont getFont(BaseFont bf, BaseFont bold, PDFContentPart textPart) {
        if (textPart.isBold()) {
            return bold;
        }
        return bf;
    }

    protected BaseFont createFont(String path) throws DocumentException, IOException {
        return BaseFont.createFont((String)path, (String)"Identity-H", (boolean)true);
    }

    protected void addBorder(Document document, PdfContentByte cb, float ypos, float posBegin) {
        cb.moveTo(22.0f, posBegin + 5.0f);
        cb.lineTo(document.getPageSize().getWidth() - 5.0f, posBegin + 5.0f);
        cb.lineTo(document.getPageSize().getWidth() - 5.0f, ypos + 5.0f);
        cb.lineTo(22.0f, ypos + 5.0f);
        cb.lineTo(22.0f, posBegin + 5.0f);
        cb.stroke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] joinPdf(byte[] ... pdfList) throws Exception {
        byte[] byArray;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PDFUtil.class.getClassLoader());
        ByteArrayOutputStream byteOut = null;
        BufferedOutputStream out = null;
        try {
            byteOut = new ByteArrayOutputStream(1024);
            out = new BufferedOutputStream(byteOut);
            Rectangle docRect = new Rectangle(595.0f, 842.0f);
            Document document = new Document(docRect);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)out);
            pdfWriter.setCloseStream(false);
            document.open();
            PdfContentByte cb = pdfWriter.getDirectContent();
            for (byte[] pdf : pdfList) {
                PdfReader reader = new PdfReader(pdf);
                int pageCount = reader.getNumberOfPages();
                for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                    PdfImportedPage page = pdfWriter.getImportedPage(reader, pageNum);
                    document.newPage();
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
            }
            document.close();
            byArray = byteOut.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(byteOut);
            IOUtils.closeQuietly(out);
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)byteOut);
        IOUtils.closeQuietly((OutputStream)out);
        Thread.currentThread().setContextClassLoader(cl);
        return byArray;
    }

    private void embedImage(PDFImage image, PdfContentByte cb, float textWidth, float textHeight) throws Exception {
        if (image == null || image.getData() == null || image.getData().length == 0) {
            return;
        }
        Image img = Image.getInstance((byte[])image.getData());
        float x = 0.0f;
        float y = 0.0f;
        switch (image.getPosition()) {
            case TOP_LEFT: {
                x = image.getMarginX();
                y = textHeight - image.getHeight() - image.getMarginY();
                break;
            }
            case TOP_RIGHT: {
                x = textWidth - image.getWidth() - image.getMarginX();
                y = textHeight - image.getHeight() - image.getMarginY();
                break;
            }
            case BOTTOM_LEFT: {
                x = image.getMarginX();
                y = image.getMarginY();
                break;
            }
            case BOTTOM_RIGHT: {
                x = textWidth - image.getWidth() - image.getMarginX();
                y = image.getMarginY();
            }
        }
        cb.addImage(img, image.getWidth(), 0.0f, 0.0f, image.getHeight(), x, y, false);
    }
}

