/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.helper;

import com.gridnine.bof.midoffice.helper.PDFContent;
import com.gridnine.bof.midoffice.helper.PDFContentPart;
import com.gridnine.bof.midoffice.helper.PDFImage;
import com.gridnine.bof.midoffice.helper.PDFUtil;
import com.gridnine.bof.midoffice.helper.Position;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Test;

public class PDFUtilTest
extends TestBase {
    private static final String footer = "Test footer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wrapAsPDFTest() throws Exception {
        PDFContent[] parts = new PDFContent[4];
        PDFContentPart part1 = new PDFContentPart();
        part1.setText("Test text 1.");
        part1.setFontSize(9.5f);
        part1.setCharacterSpacing(1.25f);
        PDFContentPart part2 = new PDFContentPart();
        part2.setText("Test text 2.");
        part2.setFontSize(8.5f);
        part2.setCharacterSpacing(1.25f);
        PDFContentPart part3 = new PDFContentPart();
        part3.setText("Test text 3.");
        part3.setFontSize(7.5f);
        part3.setCharacterSpacing(1.25f);
        parts[0] = part1;
        parts[1] = part2;
        parts[2] = part3;
        this.writeFile("wrapped-text", PDFUtil.wrapAsPDF(footer, parts));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream strm = ((Object)((Object)this)).getClass().getResourceAsStream("einstein.jpg");){
            IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
        }
        PDFImage image = new PDFImage();
        image.setWidth(100.0f);
        image.setHeight(115.0f);
        image.setMarginX(10.0f);
        image.setMarginY(10.0f);
        image.setData(baos.toByteArray());
        image.setPosition(Position.TOP_LEFT);
        parts[3] = image;
        this.writeFile("wrapped-text-image-" + image.getPosition().name(), PDFUtil.wrapAsPDF(footer, parts));
        image.setPosition(Position.TOP_RIGHT);
        this.writeFile("wrapped-text-image-" + image.getPosition().name(), PDFUtil.wrapAsPDF(footer, parts));
        image.setPosition(Position.BOTTOM_LEFT);
        this.writeFile("wrapped-text-image-" + image.getPosition().name(), PDFUtil.wrapAsPDF(footer, parts));
        image.setPosition(Position.BOTTOM_RIGHT);
        this.writeFile("wrapped-text-image-" + image.getPosition().name(), PDFUtil.wrapAsPDF(footer, parts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String name, byte[] data) throws IOException {
        File file = new File(String.format("./test/%s.pdf", name));
        try (FileOutputStream strm = new FileOutputStream(file);){
            ((OutputStream)strm).write(data);
        }
        this.log.debug("PDF data written to file " + file);
    }
}

