/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;

public abstract class AbstractMetricsAdvice
extends BaseAdvice {
    private final String START_TIME_KEY = ((Object)((Object)this)).getClass().getName() + ".startTime";
    private final String KEY_KEY = ((Object)((Object)this)).getClass().getName() + ".key";

    protected String getGdsAccountClassName(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return accountCtr != null ? MiscUtil.getSimpleClassName((Class)accountCtr.getEntityType()) : null;
    }

    protected abstract String getOperation(MessageContext var1);

    protected String getGdsAccountName(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return accountCtr != null ? ((BaseGdsAccount)accountCtr.getEntity()).getName() : null;
    }

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject(this.START_TIME_KEY, (Object)System.currentTimeMillis());
        try {
            ctx.putObject(this.KEY_KEY, (Object)Metrics.key((String[])new String[]{"profiling", "gds", "requests", this.getGdsAccountClassName(ctx), this.getGdsAccountName(ctx), this.getOperation(ctx)}));
        }
        catch (Throwable t) {
            this.log.error("failed build metrics-key", t);
        }
    }

    public void after(MessageContext ctx) throws Exception {
        try {
            Long startTimeInMillis = (Long)ctx.removeObject(this.START_TIME_KEY);
            String key = (String)ctx.removeObject(this.KEY_KEY);
            if (!TextUtil.isBlank((String)key)) {
                Metrics.get().timingAndEvent(key, startTimeInMillis.longValue());
            }
        }
        catch (Throwable t) {
            this.log.error("failed sending metrics", t);
        }
    }
}

