/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class BookingFileBuilder2
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean overrideCustomer;
        SalesContext salesContext;
        EntityReference toAdd = (EntityReference)ctx.getObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE);
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        if (null == toAdd) {
            SequenceNumberHelper.get().generateInc((CompositeNumber)bookingFile, BookingFile.class.getName(), null);
            salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            BookingFileBuilder2.enforceSalesContext(bookingFile, salesContext);
            overrideCustomer = true;
        } else {
            salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            if (!Objects.equals(bookingFile.getCustomerProfile(), salesContext.getClient())) {
                throw (Xeption)IncidentsHelper.addStackTraceElement((Throwable)Xeption.forDeveloper((String)"sales context client is different from booking file client", (Object[])new Object[0]), (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFile.client", (String)String.valueOf(bookingFile.getCustomerProfile())), IncidentsHelper.getContextStackTraceElement((String)"salesContext.client", (String)String.valueOf(salesContext.getClient()))});
            }
            overrideCustomer = Boolean.TRUE.equals(ctx.getObject((Enum)IBusMidofficeContextKeys.OVERRIDE_BOOKING_FILE_CUSTOMER));
        }
        if (overrideCustomer) {
            Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
            BookingHelper.copyCustomer((Customer)bookingFile.getCustomer(), (Customer)customer);
        }
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        travellers.stream().filter(t -> CollectionUtil.find((Iterable)bookingFile.getTravellers(), (String)t.getUid()) == null).forEach(bookingFile.getTravellers()::add);
    }

    private static void enforceSalesContext(BookingFile bookingFile, SalesContext salesContext) {
        bookingFile.setAgency(salesContext.getAgency());
        bookingFile.setCreateDate(new Date());
        bookingFile.setCustomerProfile(salesContext.getClient());
    }
}

