/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookingFileDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = -8098570504517260730L;
    public static final String FOLDER = "ibus-booking-trace";
    private Tracer tracer;
    private String operationName;

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
        this.operationName = properties.get("operation-name");
        TracerConfiguration config = new TracerConfiguration();
        config.setFolder(new File(Environment.getTempFolder(), FOLDER));
        config.setPolicy(new UnlimitedFilesPolicy());
        this.tracer = new Tracer();
        this.tracer.setConfiguration(config);
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        try {
            this.tracer.trace(new TraceItemImpl(data, ctx, this.operationName));
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(this.getClass());
            log.error("failed to save DebugData", (Throwable)e);
            log.error("DebugData: " + data.buildDebugInfo(true));
            throw new RuntimeException(e);
        }
    }

    static class TraceItemImpl
    implements TraceItem {
        private final String id;
        private final byte[] content;

        TraceItemImpl(DebugData data, MessageContext ctx, String operationName) {
            try {
                EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
                this.id = String.format("%s-%s-%s.xml", operationName, bfCtr != null ? TraceItemImpl.buildIds((EntityContainer<BookingFile>)bfCtr) : "unknown", Long.toString(MiscUtil.getTimestamp())).replaceAll("[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9.-]", ",");
                ArrayList addInfoList = new ArrayList();
                if (bfCtr != null) {
                    ((BookingFile)bfCtr.getEntity()).getReservations().stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).filter(TextUtil::nonBlank).forEach(pnr -> addInfoList.add(new Pair((Object)"recordLocator", pnr)));
                }
                this.content = data.buildDebugInfo(true, addInfoList).getBytes();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(BookingFileDebugHandler.class).error("failed to construct TraceItem (operationName=\"" + operationName + "\")", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void write(OutputStream stream) throws IOException {
            stream.write(this.content);
        }

        private static String buildIds(EntityContainer<BookingFile> bfCtr) {
            StringBuilder sb = new StringBuilder();
            sb.append(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity())));
            sb.append('_');
            sb.append(bfCtr.getUid());
            return sb.toString();
        }
    }
}

