/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BookingFileReloadDependentParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        this.reloadBookingFileReservations(ctx);
        this.reloadReservation(ctx);
        this.reloadProducts(ctx);
        this.reloadProduct(ctx);
    }

    private void reloadBookingFileReservations(MessageContext ctx) {
        List reservations = (List)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        if (reservations == null) {
            return;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS, reservations.stream().map(reservation -> this.reloadReservation((Reservation)reservation, (EntityContainer<BookingFile>)bfCtr)).collect(Collectors.toList()));
    }

    private void reloadReservation(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (reservation == null) {
            return;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)this.reloadReservation(reservation, (EntityContainer<BookingFile>)bfCtr));
    }

    private Reservation reloadReservation(Reservation reservation, EntityContainer<BookingFile> bfCtr) {
        Reservation newReservation = (Reservation)CollectionUtil.find((Iterable)((BookingFile)bfCtr.getEntity()).getReservations(), (String)reservation.getUid());
        if (newReservation == null) {
            throw Xeption.forDeveloper((String)"reservation with uid {0} not found in booking file {1} after reload", (Object[])new Object[]{reservation.getUid(), bfCtr.getUid()});
        }
        return newReservation;
    }

    private void reloadProducts(MessageContext ctx) {
        Collection products = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        if (products == null) {
            return;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, products.stream().map(product -> this.reloadProduct((BaseProduct)product, (EntityContainer<BookingFile>)bfCtr)).collect(Collectors.toList()));
    }

    private void reloadProduct(MessageContext ctx) {
        BaseProduct product = (BaseProduct)ctx.getObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCT);
        if (product == null) {
            return;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCT, (Object)this.reloadProduct(product, (EntityContainer<BookingFile>)bfCtr));
    }

    private BaseProduct reloadProduct(BaseProduct product, EntityContainer<BookingFile> bfCtr) {
        BaseProduct newProduct = BookingHelper.findProduct((BookingFile)((BookingFile)bfCtr.getEntity()), (String)product.getUid());
        if (newProduct == null) {
            throw Xeption.forDeveloper((String)"product with uid {0} not found in booking file {1} after reload", (Object[])new Object[]{product.getUid(), bfCtr.getUid()});
        }
        return newProduct;
    }
}

