/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.exceptions.BookingRejectException;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BookingFileReservationsMulticallAdvice
extends BaseAdvice {
    private static final String MULTICALL_EXCEPTION_KEY = BookingFileReservationsMulticallAdvice.class.getName() + ".MulticallException";

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (e instanceof MulticallException) {
            ctx.putObject(MULTICALL_EXCEPTION_KEY, (Object)e);
        }
        return false;
    }

    public void after(MessageContext ctx) {
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Boolean handleBookingRejectException = (Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.HANDLE_BOOKING_REJECT_EXCEPTION);
        EntityReference bookingFileReference = bookingFileContainer.toReference();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Map mCallRes = (Map)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_MULTICALL_RESULT);
        MulticallException mCallEx = (MulticallException)ctx.removeObject(MULTICALL_EXCEPTION_KEY);
        HashSet documents = new HashSet();
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
        if (mCallRes == null) {
            return;
        }
        ArrayList<Reservation> reservations = new ArrayList<Reservation>();
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS_PERFORMED, reservations);
        for (Map.Entry entry : mCallRes.entrySet()) {
            Collection docs;
            boolean wasException;
            Object multicallKey = entry.getKey();
            MessageContext subctx = (MessageContext)entry.getValue();
            Reservation oldReservation = null;
            if (multicallKey instanceof Reservation) {
                oldReservation = (Reservation)multicallKey;
            }
            boolean isCreateBooking = null == oldReservation;
            Throwable subCtxException = mCallEx != null ? (Throwable)mCallEx.getSubrouteExceptions().get(multicallKey) : null;
            boolean bl = wasException = subCtxException != null;
            if (isCreateBooking || !wasException) {
                List newReservations = (List)subctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATIONS);
                if (!CollectionUtil.isEmpty((Collection)newReservations)) {
                    newReservations.forEach(r -> {
                        r.setBookingFile(bookingFile);
                        bookingFile.getReservations().add(r);
                        reservations.add((Reservation)r);
                        this.handleBookingRejectException((Reservation)r, handleBookingRejectException, subCtxException);
                    });
                } else {
                    Reservation newReservation = (Reservation)subctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
                    if (newReservation != null && oldReservation != newReservation) {
                        newReservation.setBookingFile(bookingFile);
                        if (oldReservation != null) {
                            bookingFile.getReservations().remove(oldReservation);
                        }
                        bookingFile.getReservations().add(newReservation);
                        reservations.add(newReservation);
                        this.handleBookingRejectException(newReservation, handleBookingRejectException, subCtxException);
                    }
                }
                Reservation splitReservation = (Reservation)subctx.getObject((Enum)IBusMidofficeContextKeys.SPLIT_RESERVATION);
                if (splitReservation != null) {
                    splitReservation.setBookingFile(bookingFile);
                    if (!bookingFile.getReservations().contains(splitReservation)) {
                        bookingFile.getReservations().add(splitReservation);
                        reservations.add(splitReservation);
                    }
                }
            }
            if ((docs = (Collection)subctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS)) == null) continue;
            for (Object doc : docs) {
                if (doc instanceof BaseFileDocument) {
                    ((BaseFileDocument)doc).setOwner(bookingFileReference);
                } else if (doc instanceof EntityContainer) {
                    ((BaseFileDocument)((EntityContainer)doc).getEntity()).setOwner(bookingFileReference);
                }
                documents.add(doc);
            }
        }
    }

    private void handleBookingRejectException(Reservation reservation, Boolean handleBookingRejectException, Throwable subCtxException) {
        if (Boolean.TRUE.equals(handleBookingRejectException) && subCtxException instanceof BookingRejectException) {
            reservation.getProducts().forEach(prod -> ProductHandler.of((BaseProduct)prod).setStatus(prod, ProductStatus.REJECT));
            this.setReject(reservation);
        }
    }

    protected void setReject(Reservation reservation) {
    }
}

