/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.EntityOperationTracingDocument;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Map;

public class BookingOperationTracingAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = params.get("doc-name");
    }

    public void before(MessageContext ctx) throws Exception {
        if (!this.isCreateTracingDocument(ctx)) {
            return;
        }
        EntityOperationTracingDocument doc = new EntityOperationTracingDocument();
        doc.setCreated(new Date());
        ctx.putObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT, (Object)doc);
    }

    public void after(MessageContext ctx) throws Exception {
        EntityOperationTracingDocument document = (EntityOperationTracingDocument)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT);
        if (document == null || document.getParts().isEmpty()) {
            return;
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        if (bookingCtr != null) {
            document.setName(String.format("%s-%s", this.docName, ((BookingFile)bookingCtr.getEntity()).toString()));
            document.setOwner(bookingCtr.toReference());
            document.setTitle(document.getName());
            EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
            docCtr.getVersionInfo().setDataSource(this.docName);
            EntityStorage.get().save(docCtr, false);
        }
    }

    protected boolean isCreateTracingDocument(MessageContext ctx) {
        return false;
    }
}

