/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;

public class CollectMessagesProcessor
extends BaseProcessor {
    public static String DETAILS_KEY = "\u0414\u0435\u0442\u0430\u043b\u0438";
    private String resultMessageKey;

    public void configure(Map<String, String> parameters) {
        this.resultMessageKey = parameters.get("result-message-key");
    }

    public void process(MessageContext ctx) {
        if (CollectionUtil.isNotEmpty((Collection)ctx.getMessagesReadOnly())) {
            Message message = this.buildMessage(ctx.getMessagesReadOnly());
            ctx.clearMessages();
            ctx.addMessage(message);
            if (TextUtil.nonBlank((String)this.resultMessageKey)) {
                ctx.putObject(this.resultMessageKey, (Object)message);
            }
        }
    }

    private Message buildMessage(Collection<Message> messages) {
        MessageType mesType = MessageType.MESSAGE;
        for (Message mes : messages) {
            if (mes.getType() == MessageType.ERROR) {
                mesType = MessageType.ERROR;
                break;
            }
            if (mes.getType() != MessageType.WARNING) continue;
            mesType = MessageType.WARNING;
        }
        Message result = new Message();
        result.setType(mesType);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)DETAILS_KEY, (Object[])new Object[0]));
        result.setDetails(MessageHelper.toSimpleString(messages));
        return result;
    }
}

