/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingFileHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeleteReservationDocsProcessor
extends BaseProcessor {
    private final List<DocumentType> documentTypes = new ArrayList<DocumentType>();

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        String docTypes = parameters.get("document-types");
        if (TextUtil.isBlank((String)docTypes)) {
            throw Xeption.forDeveloper((String)"no param 'document-types'", (Object[])new Object[0]);
        }
        for (String name : docTypes.split(",")) {
            this.documentTypes.add(DocumentType.valueOf((String)name));
        }
        if (this.documentTypes.isEmpty()) {
            throw Xeption.forDeveloper((String)"no document types", (Object[])new Object[0]);
        }
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ArrayList<String> uids = new ArrayList<String>();
        uids.add(reservation.getUid());
        reservation.getProducts().forEach(bp -> uids.add(bp.getUid()));
        List docIndexes = BookingFileHelper.findBookingDocumentIndexes((EntityReference)bookingCtr.toReference(), this.documentTypes);
        for (BasicDocumentIndex idx : docIndexes) {
            if (!uids.contains(idx.getNavigationKey())) continue;
            EntityStorage.get().delete(EntityStorage.get().resolve(idx.getSource()));
        }
    }
}

