/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.Map;

public class GdsProfilingAdvice
extends BaseAdvice {
    private String profilingKey;
    private String startTimeKey;

    public void configure(Map<String, String> params) throws Exception {
        this.profilingKey = params.get("profiling-key");
        this.startTimeKey = String.format("start-time-%s", UUIDGenerator.generate((boolean)false).toString());
    }

    public void before(MessageContext ctx) throws Exception {
        if (TextUtil.isBlank((String)this.profilingKey)) {
            return;
        }
        ctx.putObject(this.startTimeKey, (Object)System.currentTimeMillis());
    }

    public void after(MessageContext ctx) throws Exception {
        EntityContainer subagencyCtr;
        SalesContext salesContext;
        Pcc pcc;
        if (TextUtil.isBlank((String)this.profilingKey)) {
            return;
        }
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (gdsAccountCtr == null) {
            return;
        }
        Long startTime = (Long)ctx.getMandatoryObject(this.startTimeKey);
        Profiler.get().updateTiming(String.format("%s.%s", this.profilingKey, MiscUtil.getSimpleClassName((Class)gdsAccountCtr.getEntityType())), startTime.longValue(), null);
        String suffix = ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName();
        if (TextUtil.isBlank((String)suffix) && (pcc = (Pcc)ctx.getObject((Enum)IBusMidofficeContextKeys.PCC)) != null) {
            suffix = pcc.getCode();
        }
        String key = "profiling." + this.profilingKey + '.' + MiscUtil.getSimpleClassName((Class)gdsAccountCtr.getEntityType());
        if (!TextUtil.isBlank((String)suffix)) {
            key = key + '.' + Metrics.cleanKeyPart((String)suffix);
        }
        if ((salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT)) != null && salesContext.getSubagency() != null && (subagencyCtr = EntityStorage.get().resolve(salesContext.getSubagency())) != null) {
            key = key + '.' + Metrics.cleanKeyPart((String)((Organization)subagencyCtr.getEntity()).getCode());
        }
        Metrics.get().timingAndEvent(key, startTime.longValue());
    }
}

