/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.model.GetCountriesRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GetCountriesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        int limit;
        GetCountriesRequest request = (GetCountriesRequest)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GET_COUNTRIES_REQUEST);
        Locale locale = LocaleManager.get().getCurrentLocale();
        if (request.getPattern() == null) {
            throw Xeption.forDeveloper((String)"missing pattern", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)request.getPattern())) {
            throw Xeption.forDeveloper((String)"empty pattern", (Object[])new Object[0]);
        }
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 20", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        } else {
            limit = 10;
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u043b\u0438\u043c\u0438\u0442 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: '{0}'", (Object[])new Object[]{limit}));
        }
        ArrayList<Country> result = new ArrayList<Country>();
        ArrayList searchResult = new ArrayList();
        searchResult.addAll(DictionaryCache.get().search(Country.class, request.getPattern().toLowerCase(locale)));
        searchResult.addAll(DictionaryCache.get().lookup(Country.class, request.getPattern().toUpperCase(locale), new String[0]));
        HashSet<String> codes = new HashSet<String>();
        Iterator iter = searchResult.iterator();
        while (iter.hasNext()) {
            Country country = (Country)iter.next();
            if (codes.add(country.getCode())) continue;
            iter.remove();
        }
        Collections.sort(searchResult, GetCountriesProcessor.createLocationComparator(request.getPattern(), locale));
        for (Country country : searchResult) {
            result.add(country);
            if (result.size() != limit) continue;
            break;
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.GET_COUNTRIES_RESPONSE, result);
    }

    private static Comparator<Country> createLocationComparator(final String pattern, final Locale locale) {
        return new Comparator<Country>(){

            @Override
            public int compare(Country o1, Country o2) {
                int result = MiscUtil.compare((int)GetCountriesProcessor.getPatternPosition(o1, pattern, locale), (int)GetCountriesProcessor.getPatternPosition(o2, pattern, locale));
                if (result == 0) {
                    result = MiscUtil.compare((Comparable)((Comparable)MiscUtil.findByLocale((Map)o1.getTranslations(), (Locale)locale)), (Comparable)((Comparable)MiscUtil.findByLocale((Map)o2.getTranslations(), (Locale)locale)));
                }
                return result;
            }
        };
    }

    static int getPatternPosition(Country country, String pattern, Locale locale) {
        String name = (String)MiscUtil.findByLocale((Map)country.getTranslations(), (Locale)locale);
        int result = name.indexOf(pattern);
        if (result == -1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }
}

