/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IgnoreProductsByStatusesProcessor
extends BaseProcessor {
    Set<ProductStatus> ignoreStatuses = new HashSet<ProductStatus>();

    public void configure(Map<String, String> parameters) {
        for (String str : parameters.get("ignore-statuses").split("\\,")) {
            this.ignoreStatuses.add(ProductStatus.valueOf((String)str));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List allProducts = reservation.getProducts();
        Collection correctBaseProducts = allProducts.stream().map(baseProduct -> (Product)baseProduct).filter(product -> !this.ignoreStatuses.contains(product.getStatus())).collect(Collectors.toList());
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, (Object)correctBaseProducts);
    }
}

