/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.exceptions.AbortOperationException;
import com.gridnine.xtrip.common.midoffice.exceptions.BookingAlreadyCancelledException;
import com.gridnine.xtrip.common.midoffice.exceptions.BookingAlreadyIssuedException;
import com.gridnine.xtrip.common.midoffice.exceptions.BookingWithoutErrorStatusException;
import com.gridnine.xtrip.common.midoffice.exceptions.RethrowException;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.XeptionHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.standard.ValidationXeption;
import java.util.Arrays;
import java.util.List;

public class IsBookingWithoutErrorStatusException
extends BaseRoutingKeyProvider {
    public static final String PASS = "pass";
    public static final String ERROR = "error";
    public static final String RETHROW = "rethrow";
    public static final String ABORT = "abort";
    private static List<Class<?>> IGNORE_SET_ERROR_STATUS_EXCEPTION_CLASSES = Arrays.asList(BookingAlreadyIssuedException.class, BookingAlreadyCancelledException.class, BookingWithoutErrorStatusException.class);
    private static List<String> userMessagesToRethrow = Arrays.asList(Messages.cancellationIsTemporarilyUnavailable);
    private static List<Class<? extends Exception>> exceptionsToRethrow = Arrays.asList(ValidationXeption.class);
    private static List<Class<? extends Exception>> exceptionsToAbort = Arrays.asList(AbortOperationException.class);

    public static boolean isIgnoreSetErrorStatus(Throwable exception) {
        return IGNORE_SET_ERROR_STATUS_EXCEPTION_CLASSES.stream().anyMatch(e -> e.isInstance(exception));
    }

    public String getRoutingKey(MessageContext ctx) throws Exception {
        BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
        if (parameters.isIgnoreException()) {
            return PASS;
        }
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Throwable exception = callback.getException();
        return this.lookForException(exception);
    }

    private String lookForException(Throwable exception) {
        String messageKey;
        Xeption x;
        MulticallException me;
        if (IsBookingWithoutErrorStatusException.isIgnoreSetErrorStatus(exception)) {
            return PASS;
        }
        if (exception instanceof RethrowException || exceptionsToRethrow.contains(exception.getClass())) {
            return RETHROW;
        }
        if (this.isAbortException(exception.getClass())) {
            return ABORT;
        }
        if (exception instanceof MulticallException && (me = (MulticallException)exception).getSubrouteExceptions().values().size() == 1) {
            return this.lookForException((Throwable)me.getSubrouteExceptions().values().iterator().next());
        }
        if (exception instanceof Xeption && XeptionHelper.isForUser((Xeption)(x = (Xeption)exception)) && userMessagesToRethrow.contains(messageKey = x.getEndUserMessage().getKey())) {
            return RETHROW;
        }
        Throwable cause = exception.getCause();
        String result = cause == null ? ERROR : this.lookForException(cause);
        return result;
    }

    private boolean isAbortException(Class<? extends Throwable> aClass) {
        for (Class<? extends Exception> abortClass : exceptionsToAbort) {
            if (!abortClass.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }
}

