/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.util.Date;

public class LogBalanceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        try {
            EntityReference contractorRef;
            EntityReference clientRef;
            boolean isClient;
            BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
            EntityReference customerRef = bookingFile.getCustomerProfile();
            boolean bl = isClient = !ProfileHelper.isRetailProfile((EntityReference)customerRef);
            if (isClient) {
                clientRef = customerRef;
                contractorRef = BookingHelper.getSubagency((BookingFile)bookingFile);
            } else {
                clientRef = BookingHelper.getSubagency((BookingFile)bookingFile);
                contractorRef = BookingHelper.getAgency((BookingFile)bookingFile);
            }
            EntityContainer contractorCtr = EntityStorage.get().resolve(contractorRef);
            EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
            BigDecimal creditLimit = null;
            BigDecimal terminalCredit = null;
            Boolean unlimited = null;
            if (clientCtr != null) {
                for (CreditLimitInfo item : ((Organization)clientCtr.getEntity()).getFinanceRestrictions().getCreditLimits()) {
                    if (!contractorRef.equals((Object)item.getCreditor())) continue;
                    creditLimit = item.getCreditLimit();
                    if (MiscUtil.isBetween((Date)item.getTerminalCreditDateStart(), (Date)item.getTerminalCreditDateEnd(), (Date)new Date())) {
                        terminalCredit = item.getTerminalCreditLimit();
                    }
                    unlimited = item.isUnlimited();
                    break;
                }
            }
            BigDecimal balance = MiscUtil.guarded((BigDecimal)BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)clientRef, (EntityReference)contractorRef, null, null, (BillingTransactionStatus)BillingTransactionStatus.ACTIVE, null, null)).setScale(2, 4);
            BigDecimal balance2 = MiscUtil.guarded((BigDecimal)BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)clientRef, (EntityReference)contractorRef, null, null, null, null, null)).setScale(2, 4);
            Object[] objectArray = new Object[7];
            objectArray[0] = contractorCtr != null ? ((Organization)contractorCtr.getEntity()).getFullName().toString() : "(\u043d\u0435\u0442)";
            objectArray[1] = clientCtr != null ? ((Organization)clientCtr.getEntity()).getFullName().toString() : "(\u043d\u0435\u0442)";
            objectArray[2] = balance != null ? balance.toPlainString() : "(\u043d\u0435\u0442)";
            Object object = objectArray[3] = balance2 != null ? balance2.toPlainString() : "(\u043d\u0435\u0442)";
            objectArray[4] = unlimited != null ? (unlimited.booleanValue() ? "\u0434\u0430" : "\u043d\u0435\u0442") : "(\u043d\u0435\u0442)";
            objectArray[5] = creditLimit != null ? creditLimit.toPlainString() : "(\u043d\u0435\u0442)";
            objectArray[6] = terminalCredit != null ? terminalCredit.toPlainString() : "(\u043d\u0435\u0442)";
            String details = String.format("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: %s,\n\u041a\u043b\u0438\u0435\u043d\u0442: %s,\n\u0411\u0430\u043b\u0430\u043d\u0441: %s,\n\u0411\u0430\u043b\u0430\u043d\u0441 \u043f\u043b\u0430\u043d\u043e\u0432\u044b\u0439: %s,\n\u0411\u0435\u0437\u043b\u0438\u043c\u0438\u0442\u043d\u044b\u0439 \u043a\u0440\u0435\u0434\u0438\u0442: %s,\n\u041a\u0440\u0435\u0434\u0438\u0442 \u0431\u0435\u0441\u0440\u043e\u0447\u043d\u044b\u0439: %s,\n\u041a\u0440\u0435\u0434\u0438\u0442 \u0441\u0440\u043e\u0447\u043d\u044b\u0439: %s", objectArray);
            SysLogHelper.audit((EntityReference)bookingFileCtr.toReference(), (String)"balance", (Message[])new Message[]{MessageHelper.createMessage((String)"\u0411\u0430\u043b\u0430\u043d\u0441", (String)details, (Object[])new Object[0])});
        }
        catch (Throwable t) {
            this.log.error("unexpected error has occurred", t);
            SysLogHelper.audit((EntityReference)bookingFileCtr.toReference(), (String)"balance", (Message[])new Message[]{MessageHelper.createExceptonMessage((String)"\u0411\u0430\u043b\u0430\u043d\u0441", (Throwable)t, (Object[])new Object[0])});
        }
    }
}

