/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MaskSensitiveTraceDataHelper {
    public static void addMaskedValue(MessageContext ctx, final String maskedValue) {
        MaskSensitiveTraceDataHelper.getMaskingMap(ctx).put(maskedValue, new MaskReplacement(){

            @Override
            public String getMaskedText() {
                return StringUtils.repeat((String)"*", (int)StringUtils.length((String)maskedValue));
            }
        });
    }

    public static void addMaskedValue(MessageContext ctx, String maskedValue, final String replacementString) {
        MaskSensitiveTraceDataHelper.getMaskingMap(ctx).put(maskedValue, new MaskReplacement(){

            @Override
            public String getMaskedText() {
                return replacementString;
            }
        });
    }

    public static void addMaskedPaymentCardNumberValue(MessageContext ctx, String maskedValue) {
        final String replacementText = MaskSensitiveTraceDataHelper.maskPaymentCardNumber(maskedValue);
        MaskSensitiveTraceDataHelper.getMaskingMap(ctx).put(maskedValue, new MaskReplacement(){

            @Override
            public String getMaskedText() {
                return replacementText;
            }
        });
    }

    private static String maskPaymentCardNumber(String maskedValue) {
        int endPos;
        int startPos;
        int minMaskingLength = 4;
        int maxInitialMasking = 2;
        int maxFinalMasking = 4;
        boolean minInitialMasking = true;
        int strLength = StringUtils.length((String)maskedValue);
        if (strLength - 2 - 4 >= 4) {
            startPos = 2;
            endPos = strLength - 4;
        } else if (9 <= strLength) {
            startPos = strLength - 4 - 4;
            endPos = strLength - 4;
        } else if (5 <= strLength) {
            startPos = 1;
            endPos = 5;
        } else {
            startPos = 0;
            endPos = strLength;
        }
        String replacementText = StringUtils.overlay((String)maskedValue, (String)StringUtils.repeat((String)"*", (int)(endPos - startPos)), (int)startPos, (int)endPos);
        return replacementText;
    }

    public static void maskData(MessageContext ctx, BaseFileDocument document) {
        String traceText = new String(document.getContent());
        boolean wasReplaced = false;
        for (Map.Entry<String, MaskReplacement> maskedEntry : MaskSensitiveTraceDataHelper.getMaskingMap(ctx).entrySet()) {
            if (!traceText.contains(maskedEntry.getKey())) continue;
            traceText = StringUtils.replace((String)traceText, (String)maskedEntry.getKey(), (String)maskedEntry.getValue().getMaskedText());
            wasReplaced = true;
        }
        if (wasReplaced) {
            document.setContent(traceText.getBytes());
        }
    }

    private static Map<String, MaskReplacement> getMaskingMap(MessageContext ctx) {
        HashMap result = (HashMap)ctx.getObject((Enum)IBusMidofficeContextKeys.SENSITIVE_TRACE_DATA);
        if (result == null) {
            result = new HashMap();
            ctx.putObject((Enum)IBusMidofficeContextKeys.SENSITIVE_TRACE_DATA, result);
        }
        return result;
    }

    static interface MaskReplacement {
        public String getMaskedText();
    }
}

