/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;

public class OnDemandDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "key";
    private static final String FOLDER = "ibus-trace-on-demand";
    private String key;
    private Tracer tracer;

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
        this.key = properties.get(KEY);
        TracerConfiguration config = new TracerConfiguration();
        config.setFolder(new File(Environment.getTempFolder(), FOLDER));
        config.setPolicy(new UnlimitedFilesPolicy());
        this.tracer = new Tracer();
        this.tracer.setConfiguration(config);
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        if (this.isEnabled(ctx)) {
            this.tracer.trace(new TraceItemImpl(data, this.key));
        }
    }

    private final boolean isEnabled(MessageContext ctx) {
        Set set = (Set)ctx.getObject((Enum)IBusMidofficeContextKeys.TRACE_ON_DEMAND);
        return set != null && set.contains(this.key);
    }

    private static class TraceItemImpl
    implements TraceItem {
        private final String id;
        private final byte[] content;

        TraceItemImpl(DebugData data, String key) {
            this.id = String.format("%s-%s.xml", key, Long.toString(MiscUtil.getTimestamp())).replaceAll("[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9.-]", ",");
            this.content = data.buildDebugInfo(true).getBytes();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void write(OutputStream strm) throws IOException {
            strm.write(this.content);
        }
    }
}

