/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProductStatusUpdateProcessor
extends BaseProcessor {
    private ProductStatus status;

    public void configure(Map<String, String> parameters) {
        this.status = ProductStatus.valueOf((String)parameters.get("status"));
    }

    public void process(MessageContext ctx) throws Exception {
        if (!Boolean.TRUE.equals(ctx.getObject((Enum)IBusMidofficeContextKeys.SKIP_PRODUCT_STATUS_UPDATE))) {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            Collection products = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
            List productUids = CollectionUtil.getUids((Collection)products);
            for (BaseProduct bp : reservation.getProducts()) {
                if (!productUids.isEmpty() && !productUids.contains(bp.getUid())) continue;
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                handler.setStatus(bp, this.status);
                handler.setIssueDate(bp, new Date());
            }
        }
    }
}

