/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class SalesContextValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (SalesContextHandler.superUser().equals((Object)salesContext.getAgent())) {
            return;
        }
        this.checkAgency(ctx, salesContext);
        this.checkSubagency(ctx, salesContext);
        this.checkClient(ctx, salesContext);
        this.checkAgent(ctx, salesContext);
    }

    private void checkAgency(MessageContext ctx, SalesContext salesContext) throws Exception {
        EntityReference agencyReference = salesContext.getAgency();
        if (agencyReference == null) {
            throw Xeption.forDeveloper((String)"missing agency in sales context", (Object[])new Object[0]);
        }
        EntityContainer agencyContainer = EntityStorage.get().resolve(agencyReference);
        if (agencyContainer == null) {
            throw Xeption.forDeveloper((String)"agency '{0}' from sales context was not resolved", (Object[])new Object[]{agencyReference});
        }
        Organization agency = (Organization)agencyContainer.getEntity();
        if (!agency.getTypes().contains(OrganizationType.AGENCY)) {
            throw Xeption.forAdmin((String)"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 '{1}'.", (Object[])new Object[]{agencyReference, OrganizationType.AGENCY});
        }
    }

    private void checkSubagency(MessageContext ctx, SalesContext salesContext) throws Exception {
        EntityReference subagencyReference = salesContext.getSubagency();
        if (subagencyReference == null) {
            throw Xeption.forDeveloper((String)"missing subagency in sales context", (Object[])new Object[0]);
        }
        EntityContainer subagencyContainer = EntityStorage.get().resolve(subagencyReference);
        if (subagencyContainer == null) {
            throw Xeption.forDeveloper((String)"subagency '{0}' from sales context was not resolved", (Object[])new Object[]{subagencyReference});
        }
        Organization subagency = (Organization)subagencyContainer.getEntity();
        if (!subagency.getTypes().contains(OrganizationType.AGENCY)) {
            throw Xeption.forAdmin((String)"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 '{1}'.", (Object[])new Object[]{subagencyReference, OrganizationType.AGENCY});
        }
    }

    private void checkClient(MessageContext ctx, SalesContext salesContext) throws Exception {
        EntityReference clientReference = salesContext.getClient();
        if (clientReference == null) {
            throw Xeption.forDeveloper((String)"missing client in sales context", (Object[])new Object[0]);
        }
        EntityContainer clientContainer = EntityStorage.get().resolve(clientReference);
        if (clientContainer == null) {
            throw Xeption.forDeveloper((String)"client '{0}' from sales context was not resolved", (Object[])new Object[]{clientReference});
        }
        Organization client = (Organization)clientContainer.getEntity();
        if (!client.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            throw Xeption.forAdmin((String)"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 '{1}'.", (Object[])new Object[]{clientReference, OrganizationType.CORPORATE_CLIENT});
        }
        if (ProfileHelper.isRetailProfile((Organization)client)) {
            return;
        }
        EntityReference subagencyReference = salesContext.getSubagency();
        this.checkClientAssociation((EntityReference<Organization>)subagencyReference, (EntityContainer<Organization>)clientContainer);
    }

    protected void checkClientAssociation(EntityReference<Organization> subagencyReference, EntityContainer<Organization> clientContainer) {
        if (!MiscUtil.equals(subagencyReference, (Object)((Organization)clientContainer.getEntity()).getParent())) {
            throw Xeption.forAdmin((String)"\u041a\u043b\u0438\u0435\u043d\u0442 '{0}' \u043d\u0435 \u0430\u0441\u0441\u043e\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u043e\u043c '{1}'.", (Object[])new Object[]{clientContainer.toReference(), subagencyReference});
        }
    }

    protected void checkAgent(MessageContext ctx, SalesContext salesContext) throws Exception {
        EntityReference agentReference = salesContext.getAgent();
        if (agentReference == null) {
            throw Xeption.forDeveloper((String)"missing agent in sales context", (Object[])new Object[0]);
        }
        EntityContainer agentContainer = EntityStorage.get().resolve(agentReference);
        if (agentContainer == null) {
            throw Xeption.forDeveloper((String)"agent '{0}' from sales context was not resolved", (Object[])new Object[]{agentReference});
        }
        Person agent = (Person)agentContainer.getEntity();
        if (!agent.getTypes().contains(PersonType.AGENT) && !agent.getTypes().contains(PersonType.WEB_AGENT)) {
            throw Xeption.forAdmin((String)"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 '{1}' \u0438\u043b\u0438 '{2}'.", (Object[])new Object[]{agentReference, PersonType.AGENT, PersonType.WEB_AGENT});
        }
    }
}

