/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = 1L;
    private Tracer tracer;
    private String operationName;

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
        this.operationName = properties.get("operation-name");
        TracerConfiguration config = new TracerConfiguration();
        config.setFolder(new File(Environment.getTempFolder(), "ibus-booking-trace"));
        config.setPolicy(new UnlimitedFilesPolicy());
        this.tracer = new Tracer();
        this.tracer.setConfiguration(config);
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        try {
            this.tracer.trace(new TraceItemImpl(data, ctx, this.operationName));
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(this.getClass());
            log.error("failed to save DebugData", (Throwable)e);
            log.error("DebugData: " + data.buildDebugInfo(true));
            throw new RuntimeException(e);
        }
    }

    static class TraceItemImpl
    implements TraceItem {
        private final String id;
        private final byte[] content;

        TraceItemImpl(DebugData data, MessageContext ctx, String operationName) {
            try {
                this.id = String.format("%s-%s.xml", operationName, Long.toString(MiscUtil.getTimestamp())).replaceAll("[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9.-]", ",");
                this.content = data.buildDebugInfo(true).getBytes();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(TripDebugHandler.class).error("failed to construct TraceItem (operationName=\"" + operationName + "\")", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void write(OutputStream strm) throws IOException {
            strm.write(this.content);
        }
    }
}

