/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeCommission;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeContractRelationData;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplyRulesToAncillariesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean isSaveRulesTraces;
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_COPY);
        EntityContainer clone = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Map reservationAncillaryFees = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_ANCILLARY_FEES);
        Map virtualProductsMap = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.VIRTUAL_PRODUCTS_MAP);
        DebugInfo debugInfo = (DebugInfo)ctx.getObject((Enum)IBusMidofficeContextKeys.DEBUG_INFO);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean bl = isSaveRulesTraces = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        if (debugInfo != null) {
            debugInfo.startBlock("rules");
        }
        ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(clone, false, false, new ArrayList(), new HashMap(), debugInfo);
        for (List fees : reservationAncillaryFees.values()) {
            for (BaseAncillaryFee fee : fees) {
                BaseProduct virtualProduct = (BaseProduct)virtualProductsMap.get(fee);
                fee.getContractRelations().clear();
                for (GeneralProductContractRelationData relation : GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)virtualProduct)) {
                    AncillaryFeeContractRelationData rd = new AncillaryFeeContractRelationData();
                    fee.getContractRelations().add(rd);
                    rd.setCurrency(relation.getGeneralData().getCurrency());
                    rd.setDescription(relation.getDescription());
                    rd.setPrice(relation.getServiceData().getTotalPrice());
                    for (GeneralProductCommission commission : relation.getCommissions()) {
                        AncillaryFeeCommission comm = new AncillaryFeeCommission();
                        rd.getCommissions().add(comm);
                        comm.setAmount(commission.getAmount());
                        comm.setCommissionProperties(commission.getCommissionProperties());
                        comm.setEquivalentAmount(commission.getEquivalentAmount());
                        comm.setRate(commission.getRate());
                    }
                }
                if (!isSaveRulesTraces) continue;
                virtualProduct.getReservation().getBookingFile().getAppliedRules().stream().filter(r -> MiscUtil.equals((Object)r.getProductUid(), (Object)virtualProduct.getUid())).forEach(rule -> {
                    EntityReference rulesContainerRef = rule.getRulesContainer();
                    builder.traceFlightLogic(fee, MessageType.MESSAGE, "applied rule: contract = " + rule.getContract() + ", ruleContainer = " + rulesContainerRef + "; " + rule.getRuleName() + ": " + rule.getRuleDescription());
                });
            }
        }
        if (debugInfo != null) {
            debugInfo.endBlock();
        }
        if (debugInfo != null) {
            EntityContainer docCtr = new EntityContainer(Document.class, "ancillaries-rules-" + TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity())));
            Document doc = (Document)docCtr.getEntity();
            doc.setType(DocumentType.DEBUG_RULES);
            doc.setName("ancillaries rules -" + TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity())) + ".xml");
            doc.setTitle(doc.getName());
            doc.setOwner(bookingFileContainer.toReference());
            doc.setContentType(ContentType.XML);
            doc.setContent(debugInfo.buildDebugInfo().getBytes());
            EntityStorage.get().save(docCtr, true);
        }
    }
}

