/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.complementBooking;

import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingData;
import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingHandlersRegistry;
import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementReservationProperties;
import com.gridnine.bof.midoffice.ibus.complementBooking.IComplementBookingHandler;
import com.gridnine.xtrip.common.midoffice.model.BaseComplementBookingHandlerSettings;
import com.gridnine.xtrip.common.midoffice.model.ComplementBookingSettings;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.standard.ComplementBookingActionSet;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeTargets;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComplementBookingHelper {
    public static final String SYS_LOG_TAG = "complement";
    public static final Message NO_ACTIVE_HANDLERS_MESSAGE = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a, \u043d\u0435\u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u0438\u043b\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0445 \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439", (Object[])new Object[0]);
    private static final Comparator<IComplementBookingHandler> HANDLER_COMPARATOR = (a, b) -> {
        if (a.getRunAfterIds().contains(b.getId())) {
            return 1;
        }
        if (b.getRunAfterIds().contains(a.getId())) {
            return -1;
        }
        return 0;
    };

    public static Map<String, ComplementBookingData> getActiveHandlersDataMap(BookingFile booking) throws Exception {
        ComplementBookingSettings settings = SystemHelper.searchSystemSettings(ComplementBookingSettings.class).stream().findFirst().orElse(null);
        if (settings == null) {
            return Collections.emptyMap();
        }
        RuleSet rules = settings.getRuleSet();
        ArrayList<RuleProxy> proxies = new ArrayList<RuleProxy>();
        for (Reservation reservation : booking.getReservations()) {
            RuleProxy proxy = new RuleProxy();
            proxy.setProxyType(MidofficeTargets.COMPLEMENT_BOOKING.getId());
            proxy.setProxyDate(new Date());
            proxy.setPropertySet((Object)new ComplementReservationProperties(reservation));
            proxy.setActionSet((Object)new ComplementBookingActionSet());
            proxies.add(proxy);
        }
        RuleEngine.applyRules(proxies, (RuleSet)rules);
        HashMap<String, ComplementBookingData> result = new HashMap<String, ComplementBookingData>();
        for (RuleProxy proxy : proxies) {
            Reservation reservation = ((ComplementReservationProperties)proxy.getPropertySet()).getReservation();
            ((ComplementBookingActionSet)proxy.getActionSet()).getActiveHandlers().forEach(handler -> {
                ComplementBookingData data = (ComplementBookingData)result.get(handler.getHandlerId());
                if (data == null) {
                    data = new ComplementBookingData((BaseComplementBookingHandlerSettings)handler);
                    result.put(handler.getHandlerId(), data);
                }
                data.getReservations().add(reservation);
            });
        }
        return result;
    }

    public static boolean isComplementBookingValid(BookingFile bookingFile) {
        boolean hasProductsInStatusSell = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).anyMatch(bp -> GeneralProductHelper.getStatus((BaseProduct)bp) == ProductStatus.SELL);
        return hasProductsInStatusSell;
    }

    private static Stream<IComplementBookingHandler> getComplementBookingHandlersStream() {
        return ComplementBookingHandlersRegistry.get().getHandlers().stream().filter(handler -> !MiscUtil.isTrue((String)System.getProperty(String.format("midoffice.complementBooking.%s.disabled", handler.getId()))));
    }

    public static List<IComplementBookingHandler> getSortedComplementBookingHandlers() {
        return ComplementBookingHelper.getComplementBookingHandlersStream().sorted(HANDLER_COMPARATOR).collect(Collectors.toList());
    }

    public static boolean hasActiveComplementBookingHandlers(Map<String, ComplementBookingData> activeHandlersMap) {
        if (activeHandlersMap.isEmpty()) {
            return false;
        }
        return ComplementBookingHelper.getComplementBookingHandlersStream().anyMatch(handler -> ComplementBookingHelper.isComplementBookingHandlerApplicable(handler, activeHandlersMap));
    }

    public static boolean isComplementBookingHandlerApplicable(IComplementBookingHandler handler, Map<String, ComplementBookingData> activeHandlersMap) {
        ComplementBookingData complementData = activeHandlersMap.get(handler.getId());
        return complementData != null && handler.isApplicable(complementData);
    }
}

