/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.complementBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingData;
import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingHelper;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplementBookingInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 999.0;
    }

    public abstract boolean isComplementAvailable(BookingFile var1);

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        BookingFile bookingFile = (BookingFile)data.getEntity();
        EntityContainer oldBookingCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        if (!ComplementBookingHelper.isComplementBookingValid(bookingFile)) {
            return;
        }
        if (oldBookingCtr != null && this.productsAdded((BookingFile)oldBookingCtr.getEntity(), bookingFile)) {
            bookingFile.setComplementCompleted(false);
        }
        if (bookingFile.isComplementCompleted() || !this.isComplementAvailable(bookingFile)) {
            return;
        }
        try {
            Map<String, ComplementBookingData> activeHandlersDataMap = ComplementBookingHelper.getActiveHandlersDataMap(bookingFile);
            EntityReference ref = data.toReference();
            if (ComplementBookingHelper.hasActiveComplementBookingHandlers(activeHandlersDataMap)) {
                this.log.debug("scheduled complement booking for booking file " + data.getUid());
                AsyncExecutor.get().execute("complement-booking", (AsyncCommand & Serializable)() -> {
                    HashMap<String, EntityReference> ctx = new HashMap<String, EntityReference>();
                    ctx.put(IBusMidofficeContextKeys.BOOKING_FILE_REFERENCE.name(), ref);
                    IntegrationBusFacade.get().processRouteSync("midoffice:complement-booking:complement-booking", ctx);
                }, new AsyncCommandOption[]{AsyncCommandOption.STRICTLY_SINGLE_RUN});
            } else {
                bookingFile.setComplementCompleted(true);
                SysLogHelper.audit((EntityReference)ref, (String)"complement", (Message[])new Message[]{ComplementBookingHelper.NO_ACTIVE_HANDLERS_MESSAGE});
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)"complement interceptor failed", (Throwable)e);
        }
    }

    private boolean productsAdded(BookingFile oldBooking, BookingFile newBooking) {
        List<String> newProductUids;
        List<String> oldProductUids = this.getProductUids(oldBooking);
        return !oldProductUids.containsAll(newProductUids = this.getProductUids(newBooking));
    }

    private List<String> getProductUids(BookingFile oldBooking) {
        return BookingHelper.getBaseProductsStream((BookingFile)oldBooking).filter(bp -> GeneralProductHelper.getStatus((BaseProduct)bp) == ProductStatus.SELL).map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }
}

