/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.complementBooking;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.GdsNamePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.util.EnumUtil;
import java.util.HashSet;
import java.util.Set;

public class ComplementReservationProperties
implements SalesContextPropertiesProvider,
GdsNamePropertiesProvider {
    private final Reservation reservation;
    private final String agencyCode;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final EntityReference<Organization> client;
    private final EntityReference<Person> agent;
    private final Set<String> profileGroups = new HashSet<String>();
    private final String gdsName;

    public ComplementReservationProperties(Reservation reservation) {
        this.reservation = reservation;
        BookingFile booking = reservation.getBookingFile();
        this.agencyCode = RulesHelper.getOrganizationCode((EntityReference)booking.getAgency());
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)reservation.getSubagency());
        this.client = booking.getCustomerProfile();
        this.agent = reservation.getBookingAgent();
        this.gdsName = EnumUtil.nameOf((Enum)CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)reservation));
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public String getGdsName() {
        return this.gdsName;
    }
}

