/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.gdsTracing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class GdsTracingDocumentAdvice
extends BaseAdvice {
    protected String docName;
    protected boolean isMainDocument;
    protected boolean updateNameAfter;

    public void configure(Map<String, String> params) {
        this.docName = params.get("doc-name");
        this.isMainDocument = "true".equals(params.get("main-document"));
        this.updateNameAfter = "true".equals(params.get("update-name-after"));
    }

    public void before(MessageContext ctx) {
        Boolean disableGdsTracing = (Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.DISABLE_GDS_TRACING);
        if (Boolean.TRUE.equals(disableGdsTracing)) {
            return;
        }
        boolean documentAlreadyExists = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT_ALREADY_EXISTS)));
        if (documentAlreadyExists) {
            return;
        }
        GdsTracingDocument document = this.createTracingDocumentIfNeeded(ctx);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT, (Object)document);
        if (document == null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.DISABLE_LOG_DOCUMENT, (Object)Boolean.TRUE);
        } else if (this.isMainDocument) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT_ALREADY_EXISTS, (Object)true);
        }
    }

    protected GdsTracingDocument createTracingDocumentIfNeeded(MessageContext ctx) {
        String login = null;
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (salesContext != null) {
            EntityContainer agentCtr = EntityStorage.get().resolve(salesContext.getAgent());
            if (agentCtr != null) {
                login = ((Person)agentCtr.getEntity()).getLoginName();
            }
        } else {
            login = UserData.get().getCurrentUser();
        }
        if (login != null) {
            String compoundKey = CommonHelper.getCompoundKey((String)login);
            EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)compoundKey, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS);
            if (ctr == null) {
                return null;
            }
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctr.getEntity();
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
            if (gdsTracingSettings.isActive() && (gdsTracingSettings.isSaveSearchTraces() || gdsTracingSettings.isSaveRulesTraces())) {
                GdsTracingDocument document = new GdsTracingDocument();
                document.setName(this.buildDocumentName(ctx));
                document.setSettings(ctr.toReference());
                document.setCreated(new Date());
                return document;
            }
        }
        return null;
    }

    protected String buildDocumentName(MessageContext ctx) {
        EntityContainer bookingCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        String documentName = "";
        if (bookingCtr != null) {
            documentName = ((BookingFile)bookingCtr.getEntity()).getNumber() + "-";
        }
        documentName = gdsAccountCtr == null ? documentName + this.docName : documentName + String.format("%s-%s", this.docName, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName());
        return documentName;
    }

    public void after(MessageContext ctx) {
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        boolean documentAlreadyExists = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT_ALREADY_EXISTS)));
        if (!(document == null || document.getParts().isEmpty() || documentAlreadyExists && !this.isMainDocument)) {
            if (this.updateNameAfter) {
                document.setName(this.buildDocumentName(ctx));
            }
            EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
            docCtr.getVersionInfo().setDataSource(this.docName);
            EntityStorage.get().save(docCtr, false);
            ctx.removeObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT_ALREADY_EXISTS);
        }
    }
}

