/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.gdsTracing;

import com.gridnine.xtrip.common.gds.model.GdsAppliedRule;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.GdsTracingSearchItem;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class GdsTracingItemBuilder<T extends BaseEntity> {
    private final ConcurrentMap<T, VariantData> variantsData = new ConcurrentHashMap<T, VariantData>();
    private final StringBuffer globalLogic = new StringBuffer();

    public void traceFlightLogic(T variant, MessageType type, String message) {
        VariantData variantData = this.getVariantData(variant);
        variantData.sb.append(String.format("\n%s: %s", type, message));
    }

    private VariantData getVariantData(T variant) {
        VariantData variantData = (VariantData)this.variantsData.get(variant);
        if (variantData != null) {
            return variantData;
        }
        variantData = new VariantData();
        VariantData variantData2 = this.variantsData.putIfAbsent(variant, variantData);
        if (variantData2 != null) {
            return variantData2;
        }
        return variantData;
    }

    public <R extends BaseEntity> void registerAppliedRule(T variant, EntityReference<R> rulesContainerRef, RuleSettings rs) {
        VariantData variantData = this.getVariantData(variant);
        GdsAppliedRule rule = new GdsAppliedRule();
        rule.setRulesContainer(rulesContainerRef);
        rule.setRuleName(rs.getName());
        rule.setRuleUid(rs.getUid());
        rule.setRuleDescription(rs.getRestrictionsInfo());
        variantData.appliedRules.add(rule);
        rule.setRuleUid(rs.getUid());
    }

    public void traceGlobalLogic(String message) {
        this.globalLogic.append(message);
    }

    public void traceGlobalLogic(MessageType type, String message) {
        this.globalLogic.append(String.format("\n%s: %s", type, message));
    }

    public GdsTracingDocumentPart buildGdsTracingDocumentPart(String partName) {
        GdsTracingDocumentPart part = new GdsTracingDocumentPart();
        GdsTracingHelper.setGlobalData((GdsTracingDocumentPart)part, (String)this.globalLogic.toString());
        part.setName(partName);
        for (Map.Entry<T, VariantData> item : this.variantsDataEntries()) {
            BaseEntity variant = (BaseEntity)item.getKey();
            GdsTracingSearchItem ti = new GdsTracingSearchItem();
            ti.setSource(variant);
            GdsTracingHelper.setData((GdsTracingSearchItem)ti, (String)item.getValue().sb.toString());
            ti.getAppliedRules().addAll(item.getValue().appliedRules);
            String title = this.getTitle(variant);
            ti.setTitle(title);
            part.getVariants().add(ti);
        }
        return part;
    }

    public Set<Map.Entry<T, VariantData>> variantsDataEntries() {
        return this.variantsData.entrySet();
    }

    public String buildVariantInfo(T variant) {
        return this.variantsData.get(variant) == null ? null : ((VariantData)this.variantsData.get(variant)).sb.toString();
    }

    public void removeVariant(T variant) {
        this.variantsData.remove(variant);
    }

    protected abstract String getTitle(T var1);

    public static class VariantData {
        final StringBuilder sb = new StringBuilder();
        final List<GdsAppliedRule> appliedRules = new ArrayList<GdsAppliedRule>();
    }
}

