/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.unsell;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;

public class IsAutoRefexPossibleProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservationUids = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            if (reservationUids != null && !reservationUids.contains(res.getUid())) continue;
            for (BaseProduct bp : res.getProducts()) {
                if (refexRequest.get(bp.getUid()) != ProductStatus.REFUND) continue;
                boolean voidPossible = false;
                boolean autoRefundPossible = false;
                GdsProductRefexFinanceDetails gdsProductRefexFinanceDetails = (GdsProductRefexFinanceDetails)unsellFinanceDetails.getGdsDetails().get((Object)bp.getUid());
                if (gdsProductRefexFinanceDetails != null) {
                    voidPossible = gdsProductRefexFinanceDetails.isVoidPossible();
                    autoRefundPossible = gdsProductRefexFinanceDetails.isPossible();
                }
                if (voidPossible || autoRefundPossible) continue;
                this.log.debug(String.format("autoRefexPossible = false for bf %s because voidPossible=%s, autoRefundPossible=%s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity())), Boolean.toString(voidPossible), Boolean.toString(autoRefundPossible)));
                ctx.putObject((Enum)IBusMidofficeContextKeys.AUTO_UNSELL_POSSIBLE, (Object)Boolean.FALSE);
                return;
            }
        }
        this.log.debug(String.format("autoRefexPossible = true for bf %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()))));
        ctx.putObject((Enum)IBusMidofficeContextKeys.AUTO_UNSELL_POSSIBLE, (Object)Boolean.TRUE);
    }
}

