/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.unsell;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.ReservationStatusHandler;
import com.gridnine.xtrip.common.midoffice.exceptions.AutoUnsellImpossibleException;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.standard.ValidationXeption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class UnsellBookingFileValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservationUids = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        Collection<Reservation> reservations = this.getReservations((EntityContainer<BookingFile>)bfCtr, reservationUids);
        ReservationStatusHandler statusHandler = (ReservationStatusHandler)Environment.getPublished(ReservationStatusHandler.class);
        Reservation reservationWithInvalidStatus = reservations.stream().filter(res -> !statusHandler.isCompleted(res) && !statusHandler.isRefund(res) && !statusHandler.isExchange(res)).findFirst().orElse(null);
        if (reservationWithInvalidStatus != null) {
            String workflowStatus = statusHandler.getStatusString(reservationWithInvalidStatus);
            throw new ValidationXeption(Xeption.forEndUser((String)"REFEX_BOOKING_FILE_VALIDATOR_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_BECAUSE_THE_STATUS_OF_THE_ORDER_IS_EQUAL_TO_X", (Object[])new Object[]{workflowStatus}));
        }
        Map unsellProducts = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        for (Reservation reservation : reservations) {
            for (BaseProduct bp : reservation.getProducts()) {
                if (!unsellProducts.containsKey(bp.getUid())) continue;
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                String productName = handler.generateShortProductName(bp);
                if (handler.getNextProduct(bp) != null) {
                    throw Xeption.forDeveloper((String)"product {0} ({1}) is not final (has next product)", (Object[])new Object[]{productName, bp.getUid()});
                }
                ProductStatus productStatus = handler.getStatus(bp);
                if (productStatus != ProductStatus.SELL) {
                    throw new ValidationXeption(Xeption.forEndUser((String)"REFEX_BOOKING_FILE_VALIDATOR_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_BECAUSE_THE_STATUS_OF_THE_PRODUCT_X_IS_Y_NOT_Z", (Object[])new Object[]{productName, productStatus, ProductStatus.SELL}));
                }
                Date firstTravelDate = handler.findFirstTravelDate(bp);
                Date lastTravelDate = handler.findLastTravelDate(bp);
                if (lastTravelDate != null && lastTravelDate.before(new Date())) {
                    throw new ValidationXeption(Xeption.forEndUser((String)"REFEX_BOOKING_FILE_VALIDATOR_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_BECAUSE_THE_SERVICE_PRODUCT_X_HAS_ALREADY_BEGUN", (Object[])new Object[]{productName}));
                }
                if (!firstTravelDate.before(new Date())) continue;
                throw new AutoUnsellImpossibleException();
            }
            for (BaseProduct bp : reservation.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.EXCHANGE) continue;
                throw new AutoUnsellImpossibleException();
            }
        }
    }

    private Collection<Reservation> getReservations(EntityContainer<BookingFile> bfCtr, Collection<String> reservationUids) {
        if (bfCtr == null || bfCtr.getEntity() == null || CollectionUtil.isEmpty(reservationUids)) {
            return Collections.emptyList();
        }
        ArrayList<Reservation> res = new ArrayList<Reservation>();
        ((BookingFile)bfCtr.getEntity()).getReservations().forEach(reservation -> {
            if (reservationUids.contains(reservation.getUid())) {
                res.add((Reservation)reservation);
            }
        });
        return res;
    }
}

